<?php

namespace Database\Seeders;

use App\Models\Permission;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class HRMPermissionSeeder extends Seeder
{
    /**
     * تنفيذ عملية البذر.
     *
     * @return void
     */
    public function run()
    {
        // صلاحيات سياسات الرواتب
        $salaryPolicyPermissions = [
            [
                'name' => 'إدارة سياسات الرواتب',
                'slug' => 'manage_salary_policies',
                'description' => 'إدارة سياسات الرواتب',
                'group' => 'hrm',
                'type' => 'crud',
            ],
            [
                'name' => 'عرض سياسات الرواتب',
                'slug' => 'view_salary_policies',
                'description' => 'عرض قائمة سياسات الرواتب',
                'group' => 'hrm',
                'type' => 'view',
            ],
            [
                'name' => 'إضافة سياسة رواتب',
                'slug' => 'create_salary_policies',
                'description' => 'إضافة سياسة رواتب جديدة',
                'group' => 'hrm',
                'type' => 'action',
            ],
            [
                'name' => 'تعديل سياسة رواتب',
                'slug' => 'edit_salary_policies',
                'description' => 'تعديل بيانات سياسة الرواتب',
                'group' => 'hrm',
                'type' => 'action',
            ],
            [
                'name' => 'حذف سياسة رواتب',
                'slug' => 'delete_salary_policies',
                'description' => 'حذف سياسة رواتب',
                'group' => 'hrm',
                'type' => 'action',
            ],
        ];

        // صلاحيات شرائح الضرائب
        $taxBracketPermissions = [
            [
                'name' => 'إدارة شرائح الضرائب',
                'slug' => 'manage_tax_brackets',
                'description' => 'إدارة شرائح الضرائب',
                'group' => 'hrm',
                'type' => 'crud',
            ],
            [
                'name' => 'عرض شرائح الضرائب',
                'slug' => 'view_tax_brackets',
                'description' => 'عرض قائمة شرائح الضرائب',
                'group' => 'hrm',
                'type' => 'view',
            ],
            [
                'name' => 'إضافة شريحة ضريبة',
                'slug' => 'create_tax_brackets',
                'description' => 'إضافة شريحة ضريبة جديدة',
                'group' => 'hrm',
                'type' => 'action',
            ],
            [
                'name' => 'تعديل شريحة ضريبة',
                'slug' => 'edit_tax_brackets',
                'description' => 'تعديل بيانات شريحة الضريبة',
                'group' => 'hrm',
                'type' => 'action',
            ],
            [
                'name' => 'حذف شريحة ضريبة',
                'slug' => 'delete_tax_brackets',
                'description' => 'حذف شريحة ضريبة',
                'group' => 'hrm',
                'type' => 'action',
            ],
        ];

        // دمج الصلاحيات
        $permissions = array_merge($salaryPolicyPermissions, $taxBracketPermissions);

        // إضافة الصلاحيات إلى قاعدة البيانات
        foreach ($permissions as $permission) {
            Permission::firstOrCreate(
                ['slug' => $permission['slug']],
                [
                    'name' => $permission['name'],
                    'description' => $permission['description'],
                    'group' => $permission['group'],
                    'type' => $permission['type'],
                ]
            );
        }
    }
}
