<?php

namespace Database\Seeders;

use App\Models\Permission;
use App\Models\Role;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class FixedMaintenancePermissionsSeeder extends Seeder
{
    /**
     * تنفيذ عملية البذر.
     *
     * @return void
     */
    public function run()
    {
        // مجموعات الصلاحيات القياسية
        $permissionGroups = [
            'maintenance_financial_reports' => 'التقارير المالية للصيانة',
            'maintenance_invoices' => 'فواتير الصيانة',
            'maintenance_notifications' => 'إشعارات الصيانة',
        ];

        // إضافة مجموعات الصلاحيات إلى قاعدة البيانات
        foreach ($permissionGroups as $key => $value) {
            try {
                // التحقق من وجود المجموعة في جدول permissions
                $groupExists = Permission::where('slug', 'group_' . $key)
                    ->where('type', 'group')
                    ->exists();

                if (!$groupExists) {
                    $group = new Permission();
                    $group->name = $value;
                    $group->slug = 'group_' . $key;
                    $group->description = 'مجموعة صلاحيات ' . $value;
                    $group->group = $key;
                    $group->type = 'group';
                    $group->is_active = true;
                    $group->save();

                    // تحديث المسار والمستوى
                    $group->updatePath();
                    $group->updateLevel();

                    echo "تم إنشاء مجموعة الصلاحيات: " . $value . " (" . $key . ")\n";
                }
            } catch (\Exception $e) {
                echo "خطأ في إنشاء مجموعة الصلاحيات: " . $value . " - " . $e->getMessage() . "\n";
            }
        }

        // الصلاحيات القياسية
        $permissions = [
            // صلاحيات التقارير المالية للصيانة
            [
                'name' => 'عرض التقارير المالية',
                'slug' => 'view_maintenance_financial_reports',
                'description' => 'عرض التقارير المالية للصيانة',
                'group' => 'maintenance_financial_reports',
                'type' => 'view',
            ],
            [
                'name' => 'تصدير التقارير المالية',
                'slug' => 'export_maintenance_financial_reports',
                'description' => 'تصدير التقارير المالية للصيانة',
                'group' => 'maintenance_financial_reports',
                'type' => 'action',
            ],
            [
                'name' => 'إدارة التقارير المالية',
                'slug' => 'manage_maintenance_financial_reports',
                'description' => 'إدارة التقارير المالية للصيانة',
                'group' => 'maintenance_financial_reports',
                'type' => 'crud',
            ],

            // صلاحيات فواتير الصيانة
            [
                'name' => 'عرض فواتير الصيانة',
                'slug' => 'view_maintenance_invoices',
                'description' => 'عرض فواتير الصيانة',
                'group' => 'maintenance_invoices',
                'type' => 'view',
            ],
            [
                'name' => 'إنشاء فواتير الصيانة',
                'slug' => 'create_maintenance_invoices',
                'description' => 'إنشاء فواتير من سجلات الصيانة',
                'group' => 'maintenance_invoices',
                'type' => 'create',
            ],
            [
                'name' => 'تعديل فواتير الصيانة',
                'slug' => 'edit_maintenance_invoices',
                'description' => 'تعديل فواتير الصيانة',
                'group' => 'maintenance_invoices',
                'type' => 'edit',
            ],
            [
                'name' => 'حذف فواتير الصيانة',
                'slug' => 'delete_maintenance_invoices',
                'description' => 'حذف فواتير الصيانة',
                'group' => 'maintenance_invoices',
                'type' => 'delete',
            ],
            [
                'name' => 'إدارة فواتير الصيانة',
                'slug' => 'manage_maintenance_invoices',
                'description' => 'إدارة فواتير الصيانة',
                'group' => 'maintenance_invoices',
                'type' => 'crud',
            ],

            // صلاحيات إشعارات الصيانة
            [
                'name' => 'عرض إشعارات الصيانة',
                'slug' => 'view_maintenance_notifications',
                'description' => 'عرض إشعارات الصيانة',
                'group' => 'maintenance_notifications',
                'type' => 'view',
            ],
            [
                'name' => 'إنشاء إشعارات الصيانة',
                'slug' => 'create_maintenance_notifications',
                'description' => 'إنشاء إشعارات الصيانة',
                'group' => 'maintenance_notifications',
                'type' => 'create',
            ],
            [
                'name' => 'تعديل إشعارات الصيانة',
                'slug' => 'edit_maintenance_notifications',
                'description' => 'تعديل إشعارات الصيانة',
                'group' => 'maintenance_notifications',
                'type' => 'edit',
            ],
            [
                'name' => 'حذف إشعارات الصيانة',
                'slug' => 'delete_maintenance_notifications',
                'description' => 'حذف إشعارات الصيانة',
                'group' => 'maintenance_notifications',
                'type' => 'delete',
            ],
            [
                'name' => 'إدارة إشعارات الصيانة',
                'slug' => 'manage_maintenance_notifications',
                'description' => 'إدارة إشعارات الصيانة',
                'group' => 'maintenance_notifications',
                'type' => 'crud',
            ],
        ];

        // إنشاء الصلاحيات
        foreach ($permissions as $permission) {
            try {
                $perm = Permission::firstOrCreate(
                    ['slug' => $permission['slug']],
                    [
                        'name' => $permission['name'],
                        'description' => $permission['description'],
                        'group' => $permission['group'],
                        'type' => $permission['type'],
                        'is_active' => true,
                    ]
                );

                // تحديث المسار والمستوى
                if ($perm->wasRecentlyCreated) {
                    $perm->updatePath();
                    $perm->updateLevel();
                }

                echo "تم إنشاء الصلاحية: " . $permission['name'] . " (" . $permission['slug'] . ")\n";
            } catch (\Exception $e) {
                echo "خطأ في إنشاء الصلاحية: " . $permission['name'] . " - " . $e->getMessage() . "\n";
            }
        }

        // إضافة الصلاحيات للأدوار
        $roles = Role::all();
        $financialReportsPermissions = Permission::where('group', 'maintenance_financial_reports')->get();
        $invoicesPermissions = Permission::where('group', 'maintenance_invoices')->get();
        $notificationPermissions = Permission::where('group', 'maintenance_notifications')->get();

        foreach ($roles as $role) {
            // مدير النظام ومدير الشركة يحصلون على جميع الصلاحيات
            if ($role->name === 'مدير النظام' || $role->name === 'مدير الشركة') {
                foreach ($financialReportsPermissions as $permission) {
                    $exists = DB::table('permission_role')
                        ->where('permission_id', $permission->id)
                        ->where('role_id', $role->id)
                        ->exists();

                    if (!$exists) {
                        DB::table('permission_role')->insert([
                            'permission_id' => $permission->id,
                            'role_id' => $role->id,
                            'created_at' => now(),
                            'updated_at' => now()
                        ]);
                    }
                }

                foreach ($invoicesPermissions as $permission) {
                    $exists = DB::table('permission_role')
                        ->where('permission_id', $permission->id)
                        ->where('role_id', $role->id)
                        ->exists();

                    if (!$exists) {
                        DB::table('permission_role')->insert([
                            'permission_id' => $permission->id,
                            'role_id' => $role->id,
                            'created_at' => now(),
                            'updated_at' => now()
                        ]);
                    }
                }

                foreach ($notificationPermissions as $permission) {
                    $exists = DB::table('permission_role')
                        ->where('permission_id', $permission->id)
                        ->where('role_id', $role->id)
                        ->exists();

                    if (!$exists) {
                        DB::table('permission_role')->insert([
                            'permission_id' => $permission->id,
                            'role_id' => $role->id,
                            'created_at' => now(),
                            'updated_at' => now()
                        ]);
                    }
                }
            }
            // دور المحاسب يحصل على صلاحيات التقارير المالية وفواتير الصيانة
            elseif ($role->name === 'محاسب') {
                foreach ($financialReportsPermissions as $permission) {
                    $exists = DB::table('permission_role')
                        ->where('permission_id', $permission->id)
                        ->where('role_id', $role->id)
                        ->exists();

                    if (!$exists) {
                        DB::table('permission_role')->insert([
                            'permission_id' => $permission->id,
                            'role_id' => $role->id,
                            'created_at' => now(),
                            'updated_at' => now()
                        ]);
                    }
                }

                foreach ($invoicesPermissions as $permission) {
                    $exists = DB::table('permission_role')
                        ->where('permission_id', $permission->id)
                        ->where('role_id', $role->id)
                        ->exists();

                    if (!$exists) {
                        DB::table('permission_role')->insert([
                            'permission_id' => $permission->id,
                            'role_id' => $role->id,
                            'created_at' => now(),
                            'updated_at' => now()
                        ]);
                    }
                }
            }
            // دور الفني يحصل على صلاحيات عرض إشعارات الصيانة
            elseif ($role->name === 'فني') {
                $viewPermissions = $notificationPermissions->filter(function ($permission) {
                    return in_array($permission->slug, ['view_maintenance_notifications']);
                });

                foreach ($viewPermissions as $permission) {
                    $exists = DB::table('permission_role')
                        ->where('permission_id', $permission->id)
                        ->where('role_id', $role->id)
                        ->exists();

                    if (!$exists) {
                        DB::table('permission_role')->insert([
                            'permission_id' => $permission->id,
                            'role_id' => $role->id,
                            'created_at' => now(),
                            'updated_at' => now()
                        ]);
                    }
                }
            }
            // دور مدير الصيانة يحصل على صلاحيات إدارة إشعارات الصيانة وعرض التقارير المالية
            elseif ($role->name === 'مدير الصيانة') {
                foreach ($notificationPermissions as $permission) {
                    $exists = DB::table('permission_role')
                        ->where('permission_id', $permission->id)
                        ->where('role_id', $role->id)
                        ->exists();

                    if (!$exists) {
                        DB::table('permission_role')->insert([
                            'permission_id' => $permission->id,
                            'role_id' => $role->id,
                            'created_at' => now(),
                            'updated_at' => now()
                        ]);
                    }
                }

                $viewFinancialPermissions = $financialReportsPermissions->filter(function ($permission) {
                    return in_array($permission->slug, ['view_maintenance_financial_reports']);
                });

                foreach ($viewFinancialPermissions as $permission) {
                    $exists = DB::table('permission_role')
                        ->where('permission_id', $permission->id)
                        ->where('role_id', $role->id)
                        ->exists();

                    if (!$exists) {
                        DB::table('permission_role')->insert([
                            'permission_id' => $permission->id,
                            'role_id' => $role->id,
                            'created_at' => now(),
                            'updated_at' => now()
                        ]);
                    }
                }
            }
        }
    }
}
