<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Permission;
use App\Models\Role;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;

class FixPermissionsOrderSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Log::info('Starting FixPermissionsOrderSeeder');

        // 1. تحديث ترتيب الصلاحيات لضمان ظهورها بشكل صحيح
        $groups = Permission::distinct()->pluck('group');

        Log::info('Found ' . $groups->count() . ' permission groups');

        $order = 1;
        foreach ($groups as $group) {
            // تخطي المجموعات الفارغة
            if (empty($group)) {
                continue;
            }

            Log::info('Processing group: ' . $group);

            // تحديث ترتيب مجموعة الصلاحيات
            $parentPermission = Permission::where('slug', 'manage_' . $group)
                ->orWhere(function ($query) use ($group) {
                    $query->where('group', $group)
                        ->where('type', 'group');
                })
                ->first();

            if ($parentPermission) {
                Log::info('Updating parent permission: ' . $parentPermission->name . ' (ID: ' . $parentPermission->id . ')');

                $parentPermission->order = $order;
                $parentPermission->save();

                // تحديث ترتيب الصلاحيات الفرعية
                $childPermissions = Permission::where('parent_id', $parentPermission->id)
                    ->orWhere(function ($query) use ($group, $parentPermission) {
                        $query->where('group', $group)
                            ->where('id', '!=', $parentPermission->id);
                    })
                    ->get();

                Log::info('Found ' . $childPermissions->count() . ' child permissions for group: ' . $group);

                $childOrder = 1;
                foreach ($childPermissions as $childPermission) {
                    $childPermission->order = $childOrder;
                    $childPermission->save();
                    $childOrder++;
                }
            } else {
                Log::info('No parent permission found for group: ' . $group);

                // إذا لم يكن هناك صلاحية أب، قم بتحديث ترتيب جميع الصلاحيات في المجموعة
                $groupPermissions = Permission::where('group', $group)->get();

                Log::info('Found ' . $groupPermissions->count() . ' permissions for group: ' . $group);

                $groupOrder = 1;
                foreach ($groupPermissions as $permission) {
                    $permission->order = $groupOrder;
                    $permission->save();
                    $groupOrder++;
                }
            }

            $order++;
        }

        // 2. إضافة ترجمات للصلاحيات الجديدة في ملف العرض
        // هذا يتطلب تعديل ملف العرض، سنقوم بذلك في الخطوة التالية

        Log::info('FixPermissionsOrderSeeder completed successfully');
    }
}
