<?php

namespace Database\Seeders;

use App\Models\Company;
use App\Models\ElevatorType;
use Illuminate\Database\Seeder;

class ElevatorTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // الحصول على جميع الشركات
        $companies = Company::all();

        // أنواع المصاعد الافتراضية
        $elevatorTypes = [
            [
                'name' => 'مصعد ركاب',
                'code' => 'PASSENGER',
                'description' => 'مصعد مخصص لنقل الركاب بين الطوابق المختلفة في المباني',
                'is_active' => true,
            ],
            [
                'name' => 'مصعد بضائع',
                'code' => 'FREIGHT',
                'description' => 'مصعد مخصص لنقل البضائع والمعدات الثقيلة',
                'is_active' => true,
            ],
            [
                'name' => 'مصعد مستشفى',
                'code' => 'HOSPITAL',
                'description' => 'مصعد مصمم خصيصًا للاستخدام في المستشفيات ونقل المرضى والمعدات الطبية',
                'is_active' => true,
            ],
            [
                'name' => 'مصعد بانورامي',
                'code' => 'PANORAMIC',
                'description' => 'مصعد ذو جدران زجاجية يوفر إطلالة بانورامية أثناء الصعود والهبوط',
                'is_active' => true,
            ],
            [
                'name' => 'مصعد سكني',
                'code' => 'RESIDENTIAL',
                'description' => 'مصعد مصمم للاستخدام في المباني السكنية',
                'is_active' => true,
            ],
            [
                'name' => 'مصعد تجاري',
                'code' => 'COMMERCIAL',
                'description' => 'مصعد مصمم للاستخدام في المباني التجارية والمكاتب',
                'is_active' => true,
            ],
        ];

        // إضافة أنواع المصاعد لكل شركة
        foreach ($companies as $company) {
            foreach ($elevatorTypes as $type) {
                ElevatorType::create([
                    'company_id' => $company->id,
                    'name' => $type['name'],
                    'code' => $type['code'],
                    'description' => $type['description'],
                    'is_active' => $type['is_active'],
                ]);
            }
        }
    }
}
