<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class ElevatorStagesPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // إنشاء الصلاحيات الخاصة بمراحل المصاعد
        $permissions = [
            [
                'name' => 'view_elevator_stages',
                'slug' => 'view-elevator-stages',
                'description' => 'عرض مراحل المصاعد',
                'group' => 'المشاريع والتركيبات',
                'type' => 'action',
                'is_active' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'create_elevator_stages',
                'slug' => 'create-elevator-stages',
                'description' => 'إنشاء مرحلة مصعد جديدة',
                'group' => 'المشاريع والتركيبات',
                'type' => 'action',
                'is_active' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'edit_elevator_stages',
                'slug' => 'edit-elevator-stages',
                'description' => 'تعديل مراحل المصاعد',
                'group' => 'المشاريع والتركيبات',
                'type' => 'action',
                'is_active' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'delete_elevator_stages',
                'slug' => 'delete-elevator-stages',
                'description' => 'حذف مراحل المصاعد',
                'group' => 'المشاريع والتركيبات',
                'type' => 'action',
                'is_active' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'manage_elevator_stages',
                'slug' => 'manage-elevator-stages',
                'description' => 'إدارة مراحل المصاعد',
                'group' => 'المشاريع والتركيبات',
                'type' => 'action',
                'is_active' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ];

        // إضافة الصلاحيات إلى قاعدة البيانات
        foreach ($permissions as $permission) {
            // التحقق من وجود الصلاحية قبل إضافتها
            $exists = DB::table('permissions')->where('slug', $permission['slug'])->exists();
            if (!$exists) {
                DB::table('permissions')->insert($permission);
            }
        }

        // الحصول على معرفات الصلاحيات
        $permissionIds = [];
        foreach ($permissions as $permission) {
            $permissionRecord = DB::table('permissions')->where('slug', $permission['slug'])->first();
            if ($permissionRecord) {
                $permissionIds[] = $permissionRecord->id;
            }
        }

        // إضافة الصلاحيات للأدوار
        $roles = [
            'super_admin',
            'admin',
            'manager',
            'installation_manager',
            'installation_supervisor',
        ];

        foreach ($roles as $roleName) {
            $role = DB::table('roles')->where('name', $roleName)->first();
            if ($role) {
                foreach ($permissionIds as $permissionId) {
                    // التحقق من وجود العلاقة قبل إضافتها
                    $exists = DB::table('permission_role')
                        ->where('permission_id', $permissionId)
                        ->where('role_id', $role->id)
                        ->exists();

                    if (!$exists) {
                        DB::table('permission_role')->insert([
                            'permission_id' => $permissionId,
                            'role_id' => $role->id,
                            'created_at' => now(),
                            'updated_at' => now(),
                        ]);
                    }
                }
            }
        }

        // إضافة صلاحيات محددة للأدوار الأخرى
        $limitedRoles = [
            'accountant',
            'sales_manager',
            'technical_manager',
        ];

        // الحصول على معرف صلاحية العرض
        $viewPermission = DB::table('permissions')->where('slug', 'view-elevator-stages')->first();

        if ($viewPermission) {
            foreach ($limitedRoles as $roleName) {
                $role = DB::table('roles')->where('name', $roleName)->first();
                if ($role) {
                    // التحقق من وجود العلاقة قبل إضافتها
                    $exists = DB::table('permission_role')
                        ->where('permission_id', $viewPermission->id)
                        ->where('role_id', $role->id)
                        ->exists();

                    if (!$exists) {
                        DB::table('permission_role')->insert([
                            'permission_id' => $viewPermission->id,
                            'role_id' => $role->id,
                            'created_at' => now(),
                            'updated_at' => now(),
                        ]);
                    }
                }
            }
        }

        $this->command->info('تم إنشاء صلاحيات مراحل المصاعد بنجاح!');
    }
}
