<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class ElevatorModelsPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // إنشاء الصلاحيات الخاصة بموديلات المصاعد
        $permissions = [
            [
                'name' => 'elevator_models.view',
                'slug' => 'elevator-models-view',
                'description' => 'عرض موديلات المصاعد',
                'group' => 'المصاعد',
                'type' => 'action',
                'is_active' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'elevator_models.create',
                'slug' => 'elevator-models-create',
                'description' => 'إنشاء موديل مصعد جديد',
                'group' => 'المصاعد',
                'type' => 'action',
                'is_active' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'elevator_models.edit',
                'slug' => 'elevator-models-edit',
                'description' => 'تعديل موديلات المصاعد',
                'group' => 'المصاعد',
                'type' => 'action',
                'is_active' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'elevator_models.delete',
                'slug' => 'elevator-models-delete',
                'description' => 'حذف موديلات المصاعد',
                'group' => 'المصاعد',
                'type' => 'action',
                'is_active' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ];

        // إضافة الصلاحيات إلى قاعدة البيانات
        foreach ($permissions as $permission) {
            // التحقق من وجود الصلاحية قبل إضافتها
            $exists = DB::table('permissions')->where('name', $permission['name'])->exists();
            if (!$exists) {
                DB::table('permissions')->insert($permission);
            }
        }

        // الحصول على معرفات الصلاحيات
        $permissionIds = [];
        foreach ($permissions as $permission) {
            $permissionRecord = DB::table('permissions')->where('name', $permission['name'])->first();
            if ($permissionRecord) {
                $permissionIds[] = $permissionRecord->id;
            }
        }

        // إضافة الصلاحيات للأدوار
        $roles = [
            'super_admin',
            'admin',
            'manager',
        ];

        foreach ($roles as $roleName) {
            $role = DB::table('roles')->where('name', $roleName)->first();
            if ($role) {
                foreach ($permissionIds as $permissionId) {
                    // التحقق من وجود العلاقة قبل إضافتها
                    $exists = DB::table('permission_role')
                        ->where('permission_id', $permissionId)
                        ->where('role_id', $role->id)
                        ->exists();

                    if (!$exists) {
                        DB::table('permission_role')->insert([
                            'permission_id' => $permissionId,
                            'role_id' => $role->id,
                            'created_at' => now(),
                            'updated_at' => now(),
                        ]);
                    }
                }
            }
        }

        // إضافة صلاحيات محددة للأدوار الأخرى
        $limitedRoles = [
            'technical_manager',
            'maintenance_manager',
        ];

        // الحصول على معرف صلاحية العرض
        $viewPermission = DB::table('permissions')->where('name', 'elevator_models.view')->first();

        if ($viewPermission) {
            foreach ($limitedRoles as $roleName) {
                $role = DB::table('roles')->where('name', $roleName)->first();
                if ($role) {
                    // التحقق من وجود العلاقة قبل إضافتها
                    $exists = DB::table('permission_role')
                        ->where('permission_id', $viewPermission->id)
                        ->where('role_id', $role->id)
                        ->exists();

                    if (!$exists) {
                        DB::table('permission_role')->insert([
                            'permission_id' => $viewPermission->id,
                            'role_id' => $role->id,
                            'created_at' => now(),
                            'updated_at' => now(),
                        ]);
                    }
                }
            }
        }

        // Añadir permisos al usuario user6
        $user6 = DB::table('users')->where('email', 'user6@user6.com')->first();
        if ($user6) {
            foreach ($permissionIds as $permissionId) {
                // Verificar si ya existe la relación
                $exists = DB::table('user_permission')
                    ->where('permission_id', $permissionId)
                    ->where('user_id', $user6->id)
                    ->exists();

                if (!$exists) {
                    DB::table('user_permission')->insert([
                        'permission_id' => $permissionId,
                        'user_id' => $user6->id,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }
            }
        }

        $this->command->info('تم إنشاء صلاحيات موديلات المصاعد بنجاح!');
    }
}
