<?php

namespace Database\Seeders;

use App\Models\Permission;
use Illuminate\Database\Seeder;

class CrmPermissionsSeeder extends Seeder
{
    /**
     * تنفيذ عملية البذر.
     *
     * @return void
     */
    public function run()
    {
        // مجموعات الصلاحيات
        $permissionGroups = [
            'customer_interaction' => 'تفاعلات العملاء',
            'opportunity' => 'الفرص التجارية',
            'loyalty_point' => 'نقاط الولاء',
            'customer_reward' => 'مكافآت العملاء',
            'reward_redemption' => 'استخدام المكافآت',
        ];

        // الصلاحيات
        $permissions = [
            // صلاحيات تفاعلات العملاء
            [
                'name' => 'إدارة تفاعلات العملاء',
                'slug' => 'manage_customer_interactions',
                'description' => 'إدارة كاملة لتفاعلات العملاء',
                'group' => 'customer_interaction',
                'type' => 'crud',
            ],
            [
                'name' => 'عرض تفاعلات العملاء',
                'slug' => 'view_customer_interaction',
                'description' => 'عرض تفاعلات العملاء',
                'group' => 'customer_interaction',
                'type' => 'view',
            ],
            [
                'name' => 'إضافة تفاعل عميل',
                'slug' => 'create_customer_interaction',
                'description' => 'إضافة تفاعل عميل جديد',
                'group' => 'customer_interaction',
                'type' => 'action',
            ],
            [
                'name' => 'تعديل تفاعل عميل',
                'slug' => 'edit_customer_interaction',
                'description' => 'تعديل تفاعل عميل',
                'group' => 'customer_interaction',
                'type' => 'action',
            ],
            [
                'name' => 'حذف تفاعل عميل',
                'slug' => 'delete_customer_interaction',
                'description' => 'حذف تفاعل عميل',
                'group' => 'customer_interaction',
                'type' => 'action',
            ],

            // صلاحيات الفرص التجارية
            [
                'name' => 'إدارة الفرص التجارية',
                'slug' => 'manage_opportunities',
                'description' => 'إدارة كاملة للفرص التجارية',
                'group' => 'opportunity',
                'type' => 'crud',
            ],
            [
                'name' => 'عرض الفرص التجارية',
                'slug' => 'view_opportunity',
                'description' => 'عرض الفرص التجارية',
                'group' => 'opportunity',
                'type' => 'view',
            ],
            [
                'name' => 'إضافة فرصة تجارية',
                'slug' => 'create_opportunity',
                'description' => 'إضافة فرصة تجارية جديدة',
                'group' => 'opportunity',
                'type' => 'action',
            ],
            [
                'name' => 'تعديل فرصة تجارية',
                'slug' => 'edit_opportunity',
                'description' => 'تعديل فرصة تجارية',
                'group' => 'opportunity',
                'type' => 'action',
            ],
            [
                'name' => 'حذف فرصة تجارية',
                'slug' => 'delete_opportunity',
                'description' => 'حذف فرصة تجارية',
                'group' => 'opportunity',
                'type' => 'action',
            ],

            // صلاحيات نقاط الولاء
            [
                'name' => 'إدارة نقاط الولاء',
                'slug' => 'manage_loyalty_points',
                'description' => 'إدارة كاملة لنقاط الولاء',
                'group' => 'loyalty_point',
                'type' => 'crud',
            ],
            [
                'name' => 'عرض نقاط الولاء',
                'slug' => 'view_loyalty_point',
                'description' => 'عرض نقاط الولاء',
                'group' => 'loyalty_point',
                'type' => 'view',
            ],
            [
                'name' => 'إضافة نقاط ولاء',
                'slug' => 'create_loyalty_point',
                'description' => 'إضافة نقاط ولاء جديدة',
                'group' => 'loyalty_point',
                'type' => 'action',
            ],
            [
                'name' => 'تعديل نقاط ولاء',
                'slug' => 'edit_loyalty_point',
                'description' => 'تعديل نقاط ولاء',
                'group' => 'loyalty_point',
                'type' => 'action',
            ],
            [
                'name' => 'حذف نقاط ولاء',
                'slug' => 'delete_loyalty_point',
                'description' => 'حذف نقاط ولاء',
                'group' => 'loyalty_point',
                'type' => 'action',
            ],

            // صلاحيات مكافآت العملاء
            [
                'name' => 'إدارة مكافآت العملاء',
                'slug' => 'manage_customer_rewards',
                'description' => 'إدارة كاملة لمكافآت العملاء',
                'group' => 'customer_reward',
                'type' => 'crud',
            ],
            [
                'name' => 'عرض مكافآت العملاء',
                'slug' => 'view_customer_reward',
                'description' => 'عرض مكافآت العملاء',
                'group' => 'customer_reward',
                'type' => 'view',
            ],
            [
                'name' => 'إضافة مكافأة عميل',
                'slug' => 'create_customer_reward',
                'description' => 'إضافة مكافأة عميل جديدة',
                'group' => 'customer_reward',
                'type' => 'action',
            ],
            [
                'name' => 'تعديل مكافأة عميل',
                'slug' => 'edit_customer_reward',
                'description' => 'تعديل مكافأة عميل',
                'group' => 'customer_reward',
                'type' => 'action',
            ],
            [
                'name' => 'حذف مكافأة عميل',
                'slug' => 'delete_customer_reward',
                'description' => 'حذف مكافأة عميل',
                'group' => 'customer_reward',
                'type' => 'action',
            ],

            // صلاحيات استخدام المكافآت
            [
                'name' => 'إدارة استخدام المكافآت',
                'slug' => 'manage_reward_redemptions',
                'description' => 'إدارة كاملة لاستخدام المكافآت',
                'group' => 'reward_redemption',
                'type' => 'crud',
            ],
            [
                'name' => 'عرض استخدام المكافآت',
                'slug' => 'view_reward_redemption',
                'description' => 'عرض استخدام المكافآت',
                'group' => 'reward_redemption',
                'type' => 'view',
            ],
            [
                'name' => 'إضافة استخدام مكافأة',
                'slug' => 'create_reward_redemption',
                'description' => 'إضافة استخدام مكافأة جديد',
                'group' => 'reward_redemption',
                'type' => 'action',
            ],
            [
                'name' => 'تعديل استخدام مكافأة',
                'slug' => 'edit_reward_redemption',
                'description' => 'تعديل استخدام مكافأة',
                'group' => 'reward_redemption',
                'type' => 'action',
            ],
            [
                'name' => 'حذف استخدام مكافأة',
                'slug' => 'delete_reward_redemption',
                'description' => 'حذف استخدام مكافأة',
                'group' => 'reward_redemption',
                'type' => 'action',
            ],
        ];

        // إنشاء الصلاحيات
        foreach ($permissions as $permission) {
            Permission::firstOrCreate(
                ['slug' => $permission['slug']],
                [
                    'name' => $permission['name'],
                    'description' => $permission['description'],
                    'group' => $permission['group'],
                    'type' => $permission['type'],
                    'is_active' => true,
                ]
            );
        }
    }
}
