<?php

namespace Database\Seeders;

use App\Models\Permission;
use App\Models\Role;
use Illuminate\Database\Seeder;

class CompanySettingsPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // الحصول على مجموعة الإعدادات
        $settingsGroup = Permission::where('slug', 'manage_settings')->first();

        if ($settingsGroup) {
            // إنشاء صلاحيات إعدادات الشركة
            $permissions = [
                [
                    'name' => 'عرض إعدادات الشركة',
                    'slug' => 'view_company_settings',
                    'description' => 'عرض إعدادات الشركة',
                ],
                [
                    'name' => 'تعديل إعدادات الشركة',
                    'slug' => 'edit_company_settings',
                    'description' => 'تعديل إعدادات الشركة',
                ],
            ];

            foreach ($permissions as $permissionData) {
                // التحقق من وجود الصلاحية
                $existingPermission = Permission::where('slug', $permissionData['slug'])->first();

                if (!$existingPermission) {
                    $permission = Permission::create([
                        'parent_id' => $settingsGroup->id,
                        'name' => $permissionData['name'],
                        'slug' => $permissionData['slug'],
                        'group' => 'settings',
                        'description' => $permissionData['description'],
                        'level' => 1,
                        'path' => null,
                        'type' => 'action',
                        'resource' => 'company_settings',
                        'order' => 20, // ترتيب عالي للصلاحيات الخاصة
                        'is_active' => true,
                    ]);

                    // تحديث المسار بعد الإنشاء
                    $permission->path = $settingsGroup->path . '.' . $permission->id;
                    $permission->save();
                }
            }

            // إضافة الصلاحيات لدور المدير
            $adminRole = Role::where('slug', 'admin')->first();
            if ($adminRole) {
                $companySettingsPermissions = Permission::whereIn('slug', ['view_company_settings', 'edit_company_settings'])->get();
                $adminRole->permissions()->syncWithoutDetaching($companySettingsPermissions->pluck('id')->toArray());
            }
        }
    }
}
