<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class CompanySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // تعطيل فحص المفاتيح الأجنبية مؤقتًا
        DB::statement('SET FOREIGN_KEY_CHECKS=0');

        // حذف البيانات الموجودة
        DB::table('companies')->truncate();

        // إضافة البيانات
        $data = [
            [
                'id' => 1,
                'name' => 'شركة رقم1',
                'name_en' => null,
                'slug' => 'shrk-rkm1',
                'domain' => null,
                'database_prefix' => '1_',
                'cr_number' => null,
                'vat_number' => null,
                'email' => 'test1@company.com',
                'phone' => 1,
                'mobile' => null,
                'website' => null,
                'address' => null,
                'address_en' => null,
                'city' => null,
                'state' => null,
                'postal_code' => null,
                'tax_number' => 1,
                'country' => 'المملكة العربية السعودية',
                'logo' => null,
                'currency' => 'SAR',
                'tax_rate' => 15.00,
                'vat_rate' => 15.00,
                'is_active' => 1,
                'subscription_plan' => 'basic',
                'subscription_ends_at' => null,
                'notes' => null,
                'created_at' => '2025-09-03 09:26:13',
                'updated_at' => '2025-09-03 09:26:13',
                'deleted_at' => null,
            ],
        ];

        DB::table('companies')->insert($data);

        // إعادة تفعيل فحص المفاتيح الأجنبية
        DB::statement('SET FOREIGN_KEY_CHECKS=1');
    }
}
