<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class ChartOfAccountsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // الحصول على أول شركة في النظام
        $companyId = DB::table('companies')->value('id');

        // الحسابات الأب الخمسة الأساسية
        $mainAccounts = [
            [
                'company_id' => $companyId,
                'account_code' => '1000',
                'name' => 'الأصول',
                'name_en' => 'Assets',
                'account_type' => 'asset',
                'sub_type' => null,
                'description' => 'حسابات الأصول الرئيسية',
                'is_active' => 1,
                'is_system' => 1,
                'opening_balance' => 0,
                'current_balance' => 0,
                'currency' => 'SAR',
                'balance_type' => 'debit',
                'is_cash_account' => 0,
                'is_bank_account' => 0,
                'level' => 1,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'company_id' => $companyId,
                'account_code' => '2000',
                'name' => 'الخصوم',
                'name_en' => 'Liabilities',
                'account_type' => 'liability',
                'sub_type' => null,
                'description' => 'حسابات الخصوم الرئيسية',
                'is_active' => 1,
                'is_system' => 1,
                'opening_balance' => 0,
                'current_balance' => 0,
                'currency' => 'SAR',
                'balance_type' => 'credit',
                'is_cash_account' => 0,
                'is_bank_account' => 0,
                'level' => 1,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'company_id' => $companyId,
                'account_code' => '3000',
                'name' => 'حقوق الملكية',
                'name_en' => 'Equity',
                'account_type' => 'equity',
                'sub_type' => null,
                'description' => 'حسابات حقوق الملكية الرئيسية',
                'is_active' => 1,
                'is_system' => 1,
                'opening_balance' => 0,
                'current_balance' => 0,
                'currency' => 'SAR',
                'balance_type' => 'credit',
                'is_cash_account' => 0,
                'is_bank_account' => 0,
                'level' => 1,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'company_id' => $companyId,
                'account_code' => '4000',
                'name' => 'الإيرادات',
                'name_en' => 'Revenue',
                'account_type' => 'revenue',
                'sub_type' => null,
                'description' => 'حسابات الإيرادات الرئيسية',
                'is_active' => 1,
                'is_system' => 1,
                'opening_balance' => 0,
                'current_balance' => 0,
                'currency' => 'SAR',
                'balance_type' => 'credit',
                'is_cash_account' => 0,
                'is_bank_account' => 0,
                'level' => 1,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'company_id' => $companyId,
                'account_code' => '5000',
                'name' => 'المصروفات',
                'name_en' => 'Expenses',
                'account_type' => 'expense',
                'sub_type' => null,
                'description' => 'حسابات المصروفات الرئيسية',
                'is_active' => 1,
                'is_system' => 1,
                'opening_balance' => 0,
                'current_balance' => 0,
                'currency' => 'SAR',
                'balance_type' => 'debit',
                'is_cash_account' => 0,
                'is_bank_account' => 0,
                'level' => 1,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
        ];

        // إضافة الحسابات الأب الرئيسية
        DB::table('chart_of_accounts')->insert($mainAccounts);

        // إضافة بعض الحسابات الفرعية للأصول
        $assetAccounts = [
            [
                'company_id' => $companyId,
                'parent_id' => DB::table('chart_of_accounts')->where('account_code', '1000')->value('id'),
                'account_code' => '1100',
                'name' => 'الأصول المتداولة',
                'name_en' => 'Current Assets',
                'account_type' => 'asset',
                'sub_type' => 'current',
                'description' => 'الأصول التي يمكن تحويلها إلى نقد خلال سنة',
                'is_active' => 1,
                'is_system' => 1,
                'opening_balance' => 0,
                'current_balance' => 0,
                'currency' => 'SAR',
                'balance_type' => 'debit',
                'is_cash_account' => 0,
                'is_bank_account' => 0,
                'level' => 2,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'company_id' => $companyId,
                'parent_id' => DB::table('chart_of_accounts')->where('account_code', '1000')->value('id'),
                'account_code' => '1200',
                'name' => 'الأصول الثابتة',
                'name_en' => 'Fixed Assets',
                'account_type' => 'asset',
                'sub_type' => 'fixed',
                'description' => 'الأصول طويلة الأجل التي تستخدم في العمليات',
                'is_active' => 1,
                'is_system' => 1,
                'opening_balance' => 0,
                'current_balance' => 0,
                'currency' => 'SAR',
                'balance_type' => 'debit',
                'is_cash_account' => 0,
                'is_bank_account' => 0,
                'level' => 2,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
        ];

        // إضافة الحسابات الفرعية للأصول
        DB::table('chart_of_accounts')->insert($assetAccounts);

        // إضافة بعض الحسابات الفرعية للأصول المتداولة
        $currentAssetId = DB::table('chart_of_accounts')->where('account_code', '1100')->value('id');
        $currentAssetAccounts = [
            [
                'company_id' => $companyId,
                'parent_id' => $currentAssetId,
                'account_code' => '1110',
                'name' => 'النقدية والبنوك',
                'name_en' => 'Cash and Banks',
                'account_type' => 'asset',
                'sub_type' => 'cash',
                'description' => 'النقد في الصندوق والبنوك',
                'is_active' => 1,
                'is_system' => 1,
                'opening_balance' => 0,
                'current_balance' => 0,
                'currency' => 'SAR',
                'balance_type' => 'debit',
                'is_cash_account' => 1,
                'is_bank_account' => 0,
                'level' => 3,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'company_id' => $companyId,
                'parent_id' => $currentAssetId,
                'account_code' => '1120',
                'name' => 'الذمم المدينة',
                'name_en' => 'Accounts Receivable',
                'account_type' => 'asset',
                'sub_type' => 'receivable',
                'description' => 'المبالغ المستحقة من العملاء',
                'is_active' => 1,
                'is_system' => 1,
                'opening_balance' => 0,
                'current_balance' => 0,
                'currency' => 'SAR',
                'balance_type' => 'debit',
                'is_cash_account' => 0,
                'is_bank_account' => 0,
                'level' => 3,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'company_id' => $companyId,
                'parent_id' => $currentAssetId,
                'account_code' => '1130',
                'name' => 'المخزون',
                'name_en' => 'Inventory',
                'account_type' => 'asset',
                'sub_type' => 'inventory',
                'description' => 'البضائع المتاحة للبيع',
                'is_active' => 1,
                'is_system' => 1,
                'opening_balance' => 0,
                'current_balance' => 0,
                'currency' => 'SAR',
                'balance_type' => 'debit',
                'is_cash_account' => 0,
                'is_bank_account' => 0,
                'level' => 3,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
        ];

        // إضافة الحسابات الفرعية للأصول المتداولة
        DB::table('chart_of_accounts')->insert($currentAssetAccounts);

        // إضافة بعض الحسابات الفرعية للخصوم
        $liabilityAccounts = [
            [
                'company_id' => $companyId,
                'parent_id' => DB::table('chart_of_accounts')->where('account_code', '2000')->value('id'),
                'account_code' => '2100',
                'name' => 'الخصوم المتداولة',
                'name_en' => 'Current Liabilities',
                'account_type' => 'liability',
                'sub_type' => 'current',
                'description' => 'الالتزامات التي يجب سدادها خلال سنة',
                'is_active' => 1,
                'is_system' => 1,
                'opening_balance' => 0,
                'current_balance' => 0,
                'currency' => 'SAR',
                'balance_type' => 'credit',
                'is_cash_account' => 0,
                'is_bank_account' => 0,
                'level' => 2,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'company_id' => $companyId,
                'parent_id' => DB::table('chart_of_accounts')->where('account_code', '2000')->value('id'),
                'account_code' => '2200',
                'name' => 'الخصوم طويلة الأجل',
                'name_en' => 'Long-term Liabilities',
                'account_type' => 'liability',
                'sub_type' => 'long-term',
                'description' => 'الالتزامات التي تستحق بعد أكثر من سنة',
                'is_active' => 1,
                'is_system' => 1,
                'opening_balance' => 0,
                'current_balance' => 0,
                'currency' => 'SAR',
                'balance_type' => 'credit',
                'is_cash_account' => 0,
                'is_bank_account' => 0,
                'level' => 2,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
        ];

        // إضافة الحسابات الفرعية للخصوم
        DB::table('chart_of_accounts')->insert($liabilityAccounts);

        // إضافة بعض الحسابات الفرعية لحقوق الملكية
        $equityAccounts = [
            [
                'company_id' => $companyId,
                'parent_id' => DB::table('chart_of_accounts')->where('account_code', '3000')->value('id'),
                'account_code' => '3100',
                'name' => 'رأس المال',
                'name_en' => 'Capital',
                'account_type' => 'equity',
                'sub_type' => 'capital',
                'description' => 'رأس المال المستثمر في الشركة',
                'is_active' => 1,
                'is_system' => 1,
                'opening_balance' => 0,
                'current_balance' => 0,
                'currency' => 'SAR',
                'balance_type' => 'credit',
                'is_cash_account' => 0,
                'is_bank_account' => 0,
                'level' => 2,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'company_id' => $companyId,
                'parent_id' => DB::table('chart_of_accounts')->where('account_code', '3000')->value('id'),
                'account_code' => '3200',
                'name' => 'الأرباح المحتجزة',
                'name_en' => 'Retained Earnings',
                'account_type' => 'equity',
                'sub_type' => 'retained',
                'description' => 'الأرباح المتراكمة غير الموزعة',
                'is_active' => 1,
                'is_system' => 1,
                'opening_balance' => 0,
                'current_balance' => 0,
                'currency' => 'SAR',
                'balance_type' => 'credit',
                'is_cash_account' => 0,
                'is_bank_account' => 0,
                'level' => 2,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
        ];

        // إضافة الحسابات الفرعية لحقوق الملكية
        DB::table('chart_of_accounts')->insert($equityAccounts);

        // إضافة بعض الحسابات الفرعية للإيرادات
        $revenueAccounts = [
            [
                'company_id' => $companyId,
                'parent_id' => DB::table('chart_of_accounts')->where('account_code', '4000')->value('id'),
                'account_code' => '4100',
                'name' => 'إيرادات المبيعات',
                'name_en' => 'Sales Revenue',
                'account_type' => 'revenue',
                'sub_type' => 'sales',
                'description' => 'الإيرادات من بيع المنتجات والخدمات',
                'is_active' => 1,
                'is_system' => 1,
                'opening_balance' => 0,
                'current_balance' => 0,
                'currency' => 'SAR',
                'balance_type' => 'credit',
                'is_cash_account' => 0,
                'is_bank_account' => 0,
                'level' => 2,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'company_id' => $companyId,
                'parent_id' => DB::table('chart_of_accounts')->where('account_code', '4000')->value('id'),
                'account_code' => '4200',
                'name' => 'إيرادات الصيانة',
                'name_en' => 'Maintenance Revenue',
                'account_type' => 'revenue',
                'sub_type' => 'maintenance',
                'description' => 'الإيرادات من خدمات الصيانة',
                'is_active' => 1,
                'is_system' => 1,
                'opening_balance' => 0,
                'current_balance' => 0,
                'currency' => 'SAR',
                'balance_type' => 'credit',
                'is_cash_account' => 0,
                'is_bank_account' => 0,
                'level' => 2,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'company_id' => $companyId,
                'parent_id' => DB::table('chart_of_accounts')->where('account_code', '4000')->value('id'),
                'account_code' => '4300',
                'name' => 'إيرادات أخرى',
                'name_en' => 'Other Revenue',
                'account_type' => 'revenue',
                'sub_type' => 'other',
                'description' => 'إيرادات من مصادر أخرى',
                'is_active' => 1,
                'is_system' => 1,
                'opening_balance' => 0,
                'current_balance' => 0,
                'currency' => 'SAR',
                'balance_type' => 'credit',
                'is_cash_account' => 0,
                'is_bank_account' => 0,
                'level' => 2,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
        ];

        // إضافة الحسابات الفرعية للإيرادات
        DB::table('chart_of_accounts')->insert($revenueAccounts);

        // إضافة بعض الحسابات الفرعية للمصروفات
        $expenseAccounts = [
            [
                'company_id' => $companyId,
                'parent_id' => DB::table('chart_of_accounts')->where('account_code', '5000')->value('id'),
                'account_code' => '5100',
                'name' => 'تكلفة المبيعات',
                'name_en' => 'Cost of Sales',
                'account_type' => 'expense',
                'sub_type' => 'cost_of_sales',
                'description' => 'تكلفة البضائع المباعة',
                'is_active' => 1,
                'is_system' => 1,
                'opening_balance' => 0,
                'current_balance' => 0,
                'currency' => 'SAR',
                'balance_type' => 'debit',
                'is_cash_account' => 0,
                'is_bank_account' => 0,
                'level' => 2,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'company_id' => $companyId,
                'parent_id' => DB::table('chart_of_accounts')->where('account_code', '5000')->value('id'),
                'account_code' => '5200',
                'name' => 'مصاريف الرواتب',
                'name_en' => 'Salary Expenses',
                'account_type' => 'expense',
                'sub_type' => 'salary',
                'description' => 'مصاريف رواتب الموظفين',
                'is_active' => 1,
                'is_system' => 1,
                'opening_balance' => 0,
                'current_balance' => 0,
                'currency' => 'SAR',
                'balance_type' => 'debit',
                'is_cash_account' => 0,
                'is_bank_account' => 0,
                'level' => 2,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'company_id' => $companyId,
                'parent_id' => DB::table('chart_of_accounts')->where('account_code', '5000')->value('id'),
                'account_code' => '5300',
                'name' => 'مصاريف إدارية وعمومية',
                'name_en' => 'General and Administrative Expenses',
                'account_type' => 'expense',
                'sub_type' => 'general',
                'description' => 'المصاريف الإدارية والعمومية',
                'is_active' => 1,
                'is_system' => 1,
                'opening_balance' => 0,
                'current_balance' => 0,
                'currency' => 'SAR',
                'balance_type' => 'debit',
                'is_cash_account' => 0,
                'is_bank_account' => 0,
                'level' => 2,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'company_id' => $companyId,
                'parent_id' => DB::table('chart_of_accounts')->where('account_code', '5000')->value('id'),
                'account_code' => '5400',
                'name' => 'مصاريف التسويق والإعلان',
                'name_en' => 'Marketing and Advertising Expenses',
                'account_type' => 'expense',
                'sub_type' => 'marketing',
                'description' => 'مصاريف التسويق والإعلان',
                'is_active' => 1,
                'is_system' => 1,
                'opening_balance' => 0,
                'current_balance' => 0,
                'currency' => 'SAR',
                'balance_type' => 'debit',
                'is_cash_account' => 0,
                'is_bank_account' => 0,
                'level' => 2,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
        ];

        // إضافة الحسابات الفرعية للمصروفات
        DB::table('chart_of_accounts')->insert($expenseAccounts);
    }
}