<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class CashRegisterPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // إنشاء صلاحيات الخزائن
        $permissions = [
            [
                'name' => 'view_cash_registers',
                'guard_name' => 'web',
                'description' => 'عرض الخزائن',
                'group' => 'إدارة المالية',
            ],
            [
                'name' => 'create_cash_registers',
                'guard_name' => 'web',
                'description' => 'إنشاء خزينة جديدة',
                'group' => 'إدارة المالية',
            ],
            [
                'name' => 'edit_cash_registers',
                'guard_name' => 'web',
                'description' => 'تعديل بيانات الخزائن',
                'group' => 'إدارة المالية',
            ],
            [
                'name' => 'delete_cash_registers',
                'guard_name' => 'web',
                'description' => 'حذف الخزائن',
                'group' => 'إدارة المالية',
            ],
            [
                'name' => 'view_cash_transactions',
                'guard_name' => 'web',
                'description' => 'عرض معاملات الخزائن',
                'group' => 'إدارة المالية',
            ],
            [
                'name' => 'create_cash_transactions',
                'guard_name' => 'web',
                'description' => 'إنشاء معاملة جديدة للخزائن',
                'group' => 'إدارة المالية',
            ],
            [
                'name' => 'delete_cash_transactions',
                'guard_name' => 'web',
                'description' => 'حذف معاملات الخزائن',
                'group' => 'إدارة المالية',
            ],
        ];

        // إضافة الصلاحيات إلى قاعدة البيانات
        foreach ($permissions as $permission) {
            Permission::firstOrCreate(['name' => $permission['name']], $permission);
        }

        // إضافة الصلاحيات إلى دور المدير
        $adminRole = Role::where('name', 'admin')->first();
        if ($adminRole) {
            $adminRole->givePermissionTo($permissions);
        }

        // إضافة الصلاحيات إلى دور المحاسب
        $accountantRole = Role::where('name', 'accountant')->first();
        if ($accountantRole) {
            $accountantRole->givePermissionTo([
                'view_cash_registers',
                'view_cash_transactions',
                'create_cash_transactions',
            ]);
        }

        // إضافة الصلاحيات إلى دور المدير المالي
        $financialManagerRole = Role::where('name', 'financial_manager')->first();
        if ($financialManagerRole) {
            $financialManagerRole->givePermissionTo($permissions);
        }
    }
}
