<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class BranchSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // تعطيل فحص المفاتيح الأجنبية مؤقتًا
        DB::statement('SET FOREIGN_KEY_CHECKS=0');

        // حذف البيانات الموجودة
        DB::table('branches')->truncate();

        // إضافة البيانات
        $data = [
            [
                'id' => 1,
                'company_id' => 1,
                'name' => 'فرع رقم 1',
                'name_en' => null,
                'code' => 1,
                'manager_name' => 1,
                'phone' => null,
                'mobile' => null,
                'email' => null,
                'address' => null,
                'address_en' => null,
                'city' => null,
                'state' => null,
                'country' => 'المملكة العربية السعودية',
                'postal_code' => null,
                'location_lat' => null,
                'location_lng' => null,
                'is_main_branch' => 0,
                'is_active' => 1,
                'notes' => null,
                'created_at' => '2025-09-04 04:44:13',
                'updated_at' => '2025-09-04 04:44:13',
                'deleted_at' => null,
            ],
        ];

        DB::table('branches')->insert($data);

        // إعادة تفعيل فحص المفاتيح الأجنبية
        DB::statement('SET FOREIGN_KEY_CHECKS=1');
    }
}
