<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Permission;
use App\Models\Role;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class AutoPurchasePermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $permissions = [
            // Auto Purchase Rules
            ['name' => 'view_auto_purchase', 'description' => 'عرض قواعد الشراء التلقائي', 'group' => 'المخزون'],
            ['name' => 'create_auto_purchase', 'description' => 'إنشاء قاعدة شراء تلقائي جديدة', 'group' => 'المخزون'],
            ['name' => 'edit_auto_purchase', 'description' => 'تعديل قاعدة شراء تلقائي', 'group' => 'المخزون'],
            ['name' => 'delete_auto_purchase', 'description' => 'حذف قاعدة شراء تلقائي', 'group' => 'المخزون'],
            ['name' => 'run_auto_purchase_check', 'description' => 'تشغيل فحص المخزون وإنشاء طلبات الشراء التلقائية', 'group' => 'المخزون'],
            ['name' => 'view_auto_purchase_history', 'description' => 'عرض سجل طلبات الشراء التلقائية', 'group' => 'المخزون'],
            ['name' => 'view_auto_purchase_dashboard', 'description' => 'عرض لوحة معلومات الشراء التلقائي', 'group' => 'المخزون'],
        ];

        foreach ($permissions as $permission) {
            Permission::firstOrCreate(
                ['name' => $permission['name']],
                [
                    'slug' => str_replace('_', '-', $permission['name']),
                    'description' => $permission['description'],
                    'group' => $permission['group'],
                    'is_active' => true
                ]
            );
        }

        // إضافة الصلاحيات للأدوار
        $roles = ['super_admin', 'admin', 'inventory_manager'];

        foreach ($roles as $roleName) {
            $role = Role::where('name', $roleName)->first();
            if ($role) {
                foreach ($permissions as $permission) {
                    $permissionModel = Permission::where('name', $permission['name'])->first();
                    if ($permissionModel) {
                        // تحقق من وجود العلاقة قبل إضافتها
                        if (!$role->permissions()->where('permissions.id', $permissionModel->id)->exists()) {
                            $role->permissions()->attach($permissionModel->id);
                        }
                    }
                }
            }
        }
    }
}
