<?php

namespace Database\Seeders;

use App\Models\Permission;
use Illuminate\Database\Seeder;

class AutoPurchasePermissionSeeder extends Seeder
{
    /**
     * تنفيذ عملية البذر.
     *
     * @return void
     */
    public function run()
    {
        // مجموعة صلاحيات الشراء التلقائي
        $permissionGroup = 'auto_purchase';
        $groupName = 'الشراء التلقائي';

        // إضافة مجموعة الصلاحيات إذا لم تكن موجودة
        $this->createPermissionGroup($permissionGroup, $groupName);

        // الصلاحيات
        $permissions = [
            [
                'name' => 'إدارة الشراء التلقائي',
                'slug' => 'manage_auto_purchase',
                'description' => 'إدارة قواعد الشراء التلقائي',
                'group' => $permissionGroup,
                'type' => 'crud',
            ],
            [
                'name' => 'عرض قواعد الشراء التلقائي',
                'slug' => 'view_auto_purchase',
                'description' => 'عرض قواعد الشراء التلقائي',
                'group' => $permissionGroup,
                'type' => 'view',
            ],
            [
                'name' => 'إضافة قاعدة شراء تلقائي',
                'slug' => 'create_auto_purchase',
                'description' => 'إضافة قاعدة شراء تلقائي جديدة',
                'group' => $permissionGroup,
                'type' => 'create',
            ],
            [
                'name' => 'تعديل قاعدة شراء تلقائي',
                'slug' => 'edit_auto_purchase',
                'description' => 'تعديل قاعدة شراء تلقائي',
                'group' => $permissionGroup,
                'type' => 'edit',
            ],
            [
                'name' => 'حذف قاعدة شراء تلقائي',
                'slug' => 'delete_auto_purchase',
                'description' => 'حذف قاعدة شراء تلقائي',
                'group' => $permissionGroup,
                'type' => 'delete',
            ],
            [
                'name' => 'تشغيل فحص الشراء التلقائي',
                'slug' => 'run_auto_purchase_check',
                'description' => 'تشغيل فحص الشراء التلقائي يدوياً',
                'group' => $permissionGroup,
                'type' => 'execute',
            ],
        ];

        // إنشاء الصلاحيات
        foreach ($permissions as $permission) {
            $this->createPermission($permission);
        }
    }

    /**
     * إنشاء مجموعة صلاحيات جديدة إذا لم تكن موجودة.
     *
     * @param string $slug
     * @param string $name
     * @return void
     */
    private function createPermissionGroup($slug, $name)
    {
        // التحقق من وجود المجموعة في جدول permission_groups
        $exists = \DB::table('permission_groups')->where('slug', $slug)->exists();

        if (!$exists) {
            \DB::table('permission_groups')->insert([
                'name' => $name,
                'slug' => $slug,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }

    /**
     * إنشاء صلاحية جديدة إذا لم تكن موجودة.
     *
     * @param array $permission
     * @return void
     */
    private function createPermission($permission)
    {
        $exists = Permission::where('slug', $permission['slug'])->exists();

        if (!$exists) {
            Permission::create([
                'name' => $permission['name'],
                'slug' => $permission['slug'],
                'description' => $permission['description'],
                'group' => $permission['group'],
                'type' => $permission['type'],
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}
