<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Permission;
use App\Models\Role;
use Illuminate\Support\Facades\DB;

class AdvancedNotificationPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // إنشاء مجموعة الإشعارات المتقدمة
        $parentPermission = Permission::firstOrCreate(
            ['slug' => 'manage_advanced_notifications'],
            [
                'name' => 'إدارة الإشعارات المتقدمة',
                'slug' => 'manage_advanced_notifications',
                'group' => 'notifications',
                'description' => 'إدارة كاملة لنظام الإشعارات المتقدم',
                'level' => 0,
                'path' => null,
                'type' => 'group',
                'resource' => 'advanced_notifications',
                'order' => 0,
                'is_active' => true,
            ]
        );

        // تحديث المسار إذا كان جديداً
        if (!$parentPermission->path) {
            $parentPermission->path = $parentPermission->id;
            $parentPermission->save();
        }

        // Define advanced notification permissions
        $permissions = [
            [
                'name' => 'عرض الإشعارات العاجلة',
                'slug' => 'view_urgent_notifications',
                'description' => 'عرض قائمة الإشعارات العاجلة والحرجة',
                'type' => 'action',
                'resource' => 'urgent_notifications',
                'order' => 1,
            ],
            [
                'name' => 'إدارة إعدادات الإشعارات',
                'slug' => 'manage_notification_settings',
                'description' => 'تعديل إعدادات الإشعارات وقنوات الإرسال',
                'type' => 'action',
                'resource' => 'notification_settings',
                'order' => 2,
            ],
            [
                'name' => 'تشغيل إشعارات الصيانة',
                'slug' => 'run_maintenance_notifications',
                'description' => 'تشغيل أوامر التحقق من الصيانة وإرسال الإشعارات',
                'type' => 'action',
                'resource' => 'maintenance_notifications',
                'order' => 3,
            ],
            [
                'name' => 'عرض سجلات الإشعارات',
                'slug' => 'view_notification_logs',
                'description' => 'عرض سجلات إرسال الإشعارات والأخطاء',
                'type' => 'action',
                'resource' => 'notification_logs',
                'order' => 4,
            ],
            [
                'name' => 'تصدير الإشعارات',
                'slug' => 'export_notifications',
                'description' => 'تصدير قائمة الإشعارات إلى ملفات خارجية',
                'type' => 'action',
                'resource' => 'export_notifications',
                'order' => 5,
            ],
        ];

        // Insert permissions if they don't exist
        foreach ($permissions as $permissionData) {
            $permission = Permission::firstOrCreate(
                ['slug' => $permissionData['slug']],
                [
                    'parent_id' => $parentPermission->id,
                    'name' => $permissionData['name'],
                    'slug' => $permissionData['slug'],
                    'group' => 'notifications',
                    'description' => $permissionData['description'],
                    'level' => 1,
                    'path' => null,
                    'type' => $permissionData['type'],
                    'resource' => $permissionData['resource'],
                    'order' => $permissionData['order'],
                    'is_active' => true,
                ]
            );

            // تحديث المسار إذا كان جديداً
            if (!$permission->path) {
                $permission->path = $parentPermission->path . '.' . $permission->id;
                $permission->save();
            }
        }

        // Get roles that should have advanced notification permissions
        $adminRoles = Role::whereIn('name', ['Super Admin', 'Company Admin', 'Maintenance Manager'])->get();
        $viewRoles = Role::whereIn('name', ['Branch Manager', 'Maintenance Supervisor', 'Technician'])->get();

        // Get all advanced notification permissions
        $advancedPermissions = Permission::where('group', 'notifications')
            ->where(function ($query) {
                $query->where('slug', 'manage_advanced_notifications')
                    ->orWhere('parent_id', function ($subquery) {
                        $subquery->select('id')
                            ->from('permissions')
                            ->where('slug', 'manage_advanced_notifications');
                    });
            })
            ->get();

        // Assign all permissions to admin roles
        foreach ($adminRoles as $role) {
            foreach ($advancedPermissions as $permission) {
                // Check if the role already has the permission
                $exists = DB::table('permission_role')
                    ->where('permission_id', $permission->id)
                    ->where('role_id', $role->id)
                    ->exists();

                // If not, assign it
                if (!$exists) {
                    $role->permissions()->attach($permission->id);
                }
            }
        }

        // Assign view permissions to other roles
        foreach ($viewRoles as $role) {
            $viewPermission = $advancedPermissions->where('slug', 'view_urgent_notifications')->first();

            if ($viewPermission) {
                // Check if the role already has the permission
                $exists = DB::table('permission_role')
                    ->where('permission_id', $viewPermission->id)
                    ->where('role_id', $role->id)
                    ->exists();

                // If not, assign it
                if (!$exists) {
                    $role->permissions()->attach($viewPermission->id);
                }
            }
        }
    }
}
