<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class AccountingPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // الحصول على آخر معرف في جدول الصلاحيات
        $lastId = DB::table('permissions')->max('id');
        $nextId = $lastId + 1;

        // الحصول على آخر ترتيب للمجموعات الرئيسية
        $lastOrder = DB::table('permissions')
            ->whereNull('parent_id')
            ->max('order');
        $nextOrder = $lastOrder + 1;

        // إضافة مجموعة النظام المحاسبي
        $accountingGroupId = $nextId;
        DB::table('permissions')->insert([
            'id' => $accountingGroupId,
            'name' => 'النظام المحاسبي',
            'slug' => 'manage_accounting',
            'description' => 'إدارة كاملة للنظام المحاسبي',
            'group' => 'accounting',
            'level' => 0,
            'path' => $accountingGroupId,
            'type' => 'group',
            'resource' => 'accounting',
            'order' => $nextOrder,
            'is_active' => 1,
            'parent_id' => null,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        $nextId++;

        // إضافة صلاحيات لوحة التحكم المحاسبية
        DB::table('permissions')->insert([
            'id' => $nextId,
            'name' => 'عرض لوحة التحكم المحاسبية',
            'slug' => 'view_accounting_dashboard',
            'description' => 'عرض لوحة التحكم المحاسبية',
            'group' => 'accounting',
            'level' => 1,
            'path' => $accountingGroupId . '.' . $nextId,
            'type' => 'action',
            'resource' => 'accounting_dashboard',
            'order' => 1,
            'is_active' => 1,
            'parent_id' => $accountingGroupId,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        $nextId++;

        // إضافة صلاحيات دليل الحسابات
        $chartOfAccountsGroupId = $nextId;
        DB::table('permissions')->insert([
            'id' => $chartOfAccountsGroupId,
            'name' => 'إدارة دليل الحسابات',
            'slug' => 'manage_chart_of_accounts',
            'description' => 'إدارة كاملة لدليل الحسابات',
            'group' => 'accounting',
            'level' => 1,
            'path' => $accountingGroupId . '.' . $chartOfAccountsGroupId,
            'type' => 'group',
            'resource' => 'chart_of_accounts',
            'order' => 2,
            'is_active' => 1,
            'parent_id' => $accountingGroupId,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        $nextId++;

        // صلاحيات دليل الحسابات
        $permissions = [
            [
                'name' => 'عرض دليل الحسابات',
                'slug' => 'view_chart_of_accounts',
                'description' => 'عرض دليل الحسابات',
                'order' => 1,
            ],
            [
                'name' => 'إنشاء حساب جديد',
                'slug' => 'create_chart_of_accounts',
                'description' => 'إنشاء حساب جديد في دليل الحسابات',
                'order' => 2,
            ],
            [
                'name' => 'تعديل حساب',
                'slug' => 'edit_chart_of_accounts',
                'description' => 'تعديل حساب في دليل الحسابات',
                'order' => 3,
            ],
            [
                'name' => 'حذف حساب',
                'slug' => 'delete_chart_of_accounts',
                'description' => 'حذف حساب من دليل الحسابات',
                'order' => 4,
            ],
        ];

        foreach ($permissions as $permission) {
            DB::table('permissions')->insert([
                'id' => $nextId,
                'name' => $permission['name'],
                'slug' => $permission['slug'],
                'description' => $permission['description'],
                'group' => 'accounting',
                'level' => 2,
                'path' => $accountingGroupId . '.' . $chartOfAccountsGroupId . '.' . $nextId,
                'type' => 'action',
                'resource' => 'chart_of_accounts',
                'order' => $permission['order'],
                'is_active' => 1,
                'parent_id' => $chartOfAccountsGroupId,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
            $nextId++;
        }

        // إضافة صلاحيات القيود المحاسبية
        $journalEntriesGroupId = $nextId;
        DB::table('permissions')->insert([
            'id' => $journalEntriesGroupId,
            'name' => 'إدارة القيود المحاسبية',
            'slug' => 'manage_journal_entries',
            'description' => 'إدارة كاملة للقيود المحاسبية',
            'group' => 'accounting',
            'level' => 1,
            'path' => $accountingGroupId . '.' . $journalEntriesGroupId,
            'type' => 'group',
            'resource' => 'journal_entries',
            'order' => 3,
            'is_active' => 1,
            'parent_id' => $accountingGroupId,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        $nextId++;

        // صلاحيات القيود المحاسبية
        $permissions = [
            [
                'name' => 'عرض القيود المحاسبية',
                'slug' => 'view_journal_entries',
                'description' => 'عرض القيود المحاسبية',
                'order' => 1,
            ],
            [
                'name' => 'إنشاء قيد محاسبي',
                'slug' => 'create_journal_entries',
                'description' => 'إنشاء قيد محاسبي جديد',
                'order' => 2,
            ],
            [
                'name' => 'تعديل قيد محاسبي',
                'slug' => 'edit_journal_entries',
                'description' => 'تعديل قيد محاسبي',
                'order' => 3,
            ],
            [
                'name' => 'حذف قيد محاسبي',
                'slug' => 'delete_journal_entries',
                'description' => 'حذف قيد محاسبي',
                'order' => 4,
            ],
            [
                'name' => 'ترحيل قيد محاسبي',
                'slug' => 'post_journal_entries',
                'description' => 'ترحيل وإلغاء ترحيل القيود المحاسبية',
                'order' => 5,
            ],
            [
                'name' => 'اعتماد قيد محاسبي',
                'slug' => 'approve_journal_entries',
                'description' => 'اعتماد وإلغاء اعتماد القيود المحاسبية',
                'order' => 6,
            ],
        ];

        foreach ($permissions as $permission) {
            DB::table('permissions')->insert([
                'id' => $nextId,
                'name' => $permission['name'],
                'slug' => $permission['slug'],
                'description' => $permission['description'],
                'group' => 'accounting',
                'level' => 2,
                'path' => $accountingGroupId . '.' . $journalEntriesGroupId . '.' . $nextId,
                'type' => 'action',
                'resource' => 'journal_entries',
                'order' => $permission['order'],
                'is_active' => 1,
                'parent_id' => $journalEntriesGroupId,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
            $nextId++;
        }

        // إضافة صلاحيات قوالب القيود المحاسبية
        $journalTemplatesGroupId = $nextId;
        DB::table('permissions')->insert([
            'id' => $journalTemplatesGroupId,
            'name' => 'إدارة قوالب القيود المحاسبية',
            'slug' => 'manage_journal_templates',
            'description' => 'إدارة كاملة لقوالب القيود المحاسبية',
            'group' => 'accounting',
            'level' => 1,
            'path' => $accountingGroupId . '.' . $journalTemplatesGroupId,
            'type' => 'group',
            'resource' => 'journal_templates',
            'order' => 4,
            'is_active' => 1,
            'parent_id' => $accountingGroupId,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        $nextId++;

        // صلاحيات قوالب القيود المحاسبية
        $permissions = [
            [
                'name' => 'عرض قوالب القيود المحاسبية',
                'slug' => 'view_journal_templates',
                'description' => 'عرض قوالب القيود المحاسبية',
                'order' => 1,
            ],
            [
                'name' => 'إنشاء قالب قيد محاسبي',
                'slug' => 'create_journal_templates',
                'description' => 'إنشاء قالب قيد محاسبي جديد',
                'order' => 2,
            ],
            [
                'name' => 'تعديل قالب قيد محاسبي',
                'slug' => 'edit_journal_templates',
                'description' => 'تعديل قالب قيد محاسبي',
                'order' => 3,
            ],
            [
                'name' => 'حذف قالب قيد محاسبي',
                'slug' => 'delete_journal_templates',
                'description' => 'حذف قالب قيد محاسبي',
                'order' => 4,
            ],
        ];

        foreach ($permissions as $permission) {
            DB::table('permissions')->insert([
                'id' => $nextId,
                'name' => $permission['name'],
                'slug' => $permission['slug'],
                'description' => $permission['description'],
                'group' => 'accounting',
                'level' => 2,
                'path' => $accountingGroupId . '.' . $journalTemplatesGroupId . '.' . $nextId,
                'type' => 'action',
                'resource' => 'journal_templates',
                'order' => $permission['order'],
                'is_active' => 1,
                'parent_id' => $journalTemplatesGroupId,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
            $nextId++;
        }

        // إضافة صلاحيات السنوات المالية
        $fiscalYearsGroupId = $nextId;
        DB::table('permissions')->insert([
            'id' => $fiscalYearsGroupId,
            'name' => 'إدارة السنوات المالية',
            'slug' => 'manage_fiscal_years',
            'description' => 'إدارة كاملة للسنوات المالية',
            'group' => 'accounting',
            'level' => 1,
            'path' => $accountingGroupId . '.' . $fiscalYearsGroupId,
            'type' => 'group',
            'resource' => 'fiscal_years',
            'order' => 5,
            'is_active' => 1,
            'parent_id' => $accountingGroupId,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        $nextId++;

        // صلاحيات السنوات المالية
        $permissions = [
            [
                'name' => 'عرض السنوات المالية',
                'slug' => 'view_fiscal_years',
                'description' => 'عرض السنوات المالية',
                'order' => 1,
            ],
            [
                'name' => 'إنشاء سنة مالية',
                'slug' => 'create_fiscal_years',
                'description' => 'إنشاء سنة مالية جديدة',
                'order' => 2,
            ],
            [
                'name' => 'تعديل سنة مالية',
                'slug' => 'edit_fiscal_years',
                'description' => 'تعديل سنة مالية',
                'order' => 3,
            ],
            [
                'name' => 'حذف سنة مالية',
                'slug' => 'delete_fiscal_years',
                'description' => 'حذف سنة مالية',
                'order' => 4,
            ],
            [
                'name' => 'إغلاق سنة مالية',
                'slug' => 'close_fiscal_years',
                'description' => 'إغلاق وإعادة فتح السنوات المالية',
                'order' => 5,
            ],
        ];

        foreach ($permissions as $permission) {
            DB::table('permissions')->insert([
                'id' => $nextId,
                'name' => $permission['name'],
                'slug' => $permission['slug'],
                'description' => $permission['description'],
                'group' => 'accounting',
                'level' => 2,
                'path' => $accountingGroupId . '.' . $fiscalYearsGroupId . '.' . $nextId,
                'type' => 'action',
                'resource' => 'fiscal_years',
                'order' => $permission['order'],
                'is_active' => 1,
                'parent_id' => $fiscalYearsGroupId,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
            $nextId++;
        }

        // إضافة صلاحيات الفترات المحاسبية
        $accountingPeriodsGroupId = $nextId;
        DB::table('permissions')->insert([
            'id' => $accountingPeriodsGroupId,
            'name' => 'إدارة الفترات المحاسبية',
            'slug' => 'manage_accounting_periods',
            'description' => 'إدارة كاملة للفترات المحاسبية',
            'group' => 'accounting',
            'level' => 1,
            'path' => $accountingGroupId . '.' . $accountingPeriodsGroupId,
            'type' => 'group',
            'resource' => 'accounting_periods',
            'order' => 6,
            'is_active' => 1,
            'parent_id' => $accountingGroupId,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        $nextId++;

        // صلاحيات الفترات المحاسبية
        $permissions = [
            [
                'name' => 'عرض الفترات المحاسبية',
                'slug' => 'view_accounting_periods',
                'description' => 'عرض الفترات المحاسبية',
                'order' => 1,
            ],
            [
                'name' => 'إنشاء فترة محاسبية',
                'slug' => 'create_accounting_periods',
                'description' => 'إنشاء فترة محاسبية جديدة',
                'order' => 2,
            ],
            [
                'name' => 'تعديل فترة محاسبية',
                'slug' => 'edit_accounting_periods',
                'description' => 'تعديل فترة محاسبية',
                'order' => 3,
            ],
            [
                'name' => 'حذف فترة محاسبية',
                'slug' => 'delete_accounting_periods',
                'description' => 'حذف فترة محاسبية',
                'order' => 4,
            ],
            [
                'name' => 'إغلاق فترة محاسبية',
                'slug' => 'close_accounting_periods',
                'description' => 'إغلاق وإعادة فتح الفترات المحاسبية',
                'order' => 5,
            ],
        ];

        foreach ($permissions as $permission) {
            DB::table('permissions')->insert([
                'id' => $nextId,
                'name' => $permission['name'],
                'slug' => $permission['slug'],
                'description' => $permission['description'],
                'group' => 'accounting',
                'level' => 2,
                'path' => $accountingGroupId . '.' . $accountingPeriodsGroupId . '.' . $nextId,
                'type' => 'action',
                'resource' => 'accounting_periods',
                'order' => $permission['order'],
                'is_active' => 1,
                'parent_id' => $accountingPeriodsGroupId,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
            $nextId++;
        }

        // إضافة صلاحيات التقارير المالية
        $financialReportsGroupId = $nextId;
        DB::table('permissions')->insert([
            'id' => $financialReportsGroupId,
            'name' => 'التقارير المالية',
            'slug' => 'manage_financial_reports',
            'description' => 'إدارة كاملة للتقارير المالية',
            'group' => 'accounting',
            'level' => 1,
            'path' => $accountingGroupId . '.' . $financialReportsGroupId,
            'type' => 'group',
            'resource' => 'financial_reports',
            'order' => 7,
            'is_active' => 1,
            'parent_id' => $accountingGroupId,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        $nextId++;

        // صلاحيات التقارير المالية
        $permissions = [
            [
                'name' => 'عرض التقارير المالية',
                'slug' => 'view_financial_statements',
                'description' => 'عرض التقارير المالية (قائمة الدخل، الميزانية العمومية، التدفقات النقدية، التغيرات في حقوق الملكية)',
                'order' => 1,
            ],
            [
                'name' => 'عرض التقارير المحاسبية',
                'slug' => 'view_accounting_reports',
                'description' => 'عرض التقارير المحاسبية (ميزان المراجعة، دفتر الأستاذ العام، كشف حساب)',
                'order' => 2,
            ],
        ];

        foreach ($permissions as $permission) {
            DB::table('permissions')->insert([
                'id' => $nextId,
                'name' => $permission['name'],
                'slug' => $permission['slug'],
                'description' => $permission['description'],
                'group' => 'accounting',
                'level' => 2,
                'path' => $accountingGroupId . '.' . $financialReportsGroupId . '.' . $nextId,
                'type' => 'action',
                'resource' => 'financial_reports',
                'order' => $permission['order'],
                'is_active' => 1,
                'parent_id' => $financialReportsGroupId,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
            $nextId++;
        }
    }
}
