<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        DB::statement('ALTER TABLE elevators MODIFY model VARCHAR(255) NULL');
        DB::statement('ALTER TABLE elevators MODIFY manufacturer VARCHAR(255) NULL');
        DB::statement('ALTER TABLE elevators MODIFY installation_date DATE NULL');
        DB::statement('ALTER TABLE elevators MODIFY capacity INT NULL');
        DB::statement('ALTER TABLE elevators MODIFY floors_count INT NULL');
        DB::statement('ALTER TABLE elevators MODIFY speed DECIMAL(5, 2) NULL');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::statement('ALTER TABLE elevators MODIFY model VARCHAR(255) NOT NULL');
        DB::statement('ALTER TABLE elevators MODIFY manufacturer VARCHAR(255) NOT NULL');
        DB::statement('ALTER TABLE elevators MODIFY installation_date DATE NOT NULL');
        DB::statement('ALTER TABLE elevators MODIFY capacity INT NOT NULL');
        DB::statement('ALTER TABLE elevators MODIFY floors_count INT NOT NULL');
        DB::statement('ALTER TABLE elevators MODIFY speed DECIMAL(5, 2) NOT NULL');
    }
};
