<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Drop the existing unique constraint on invoice_number
        Schema::table('purchase_invoices', function (Blueprint $table) {
            $table->dropUnique(['invoice_number']);
        });

        // Add a new unique constraint that combines invoice_number and company_id
        Schema::table('purchase_invoices', function (Blueprint $table) {
            $table->unique(['invoice_number', 'company_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Drop the combined unique constraint
        Schema::table('purchase_invoices', function (Blueprint $table) {
            $table->dropUnique(['invoice_number', 'company_id']);
        });

        // Restore the original unique constraint on invoice_number
        Schema::table('purchase_invoices', function (Blueprint $table) {
            $table->unique(['invoice_number']);
        });
    }
};
