<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class ModifyInventoryItemsUniqueConstraints extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('inventory_items', function (Blueprint $table) {
            // Drop existing unique constraints
            $table->dropUnique('inventory_items_sku_unique');
            $table->dropUnique('inventory_items_barcode_unique');

            // Add new composite unique constraints with company_id
            $table->unique(['company_id', 'sku'], 'inventory_items_company_sku_unique');
            // For barcode, we need to handle NULL values, so we'll use a raw statement
            // This will be handled in the controller validation instead
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('inventory_items', function (Blueprint $table) {
            // Drop new composite unique constraints
            $table->dropUnique('inventory_items_company_sku_unique');

            // Restore original unique constraints
            $table->unique('sku', 'inventory_items_sku_unique');
            $table->unique('barcode', 'inventory_items_barcode_unique');
        });
    }
}
