<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('purchase_invoices', function (Blueprint $table) {
            // تعديل عمود company_id ليكون إلزاميًا بعد تحديث البيانات
            $table->unsignedBigInteger('company_id')->nullable(false)->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('purchase_invoices', function (Blueprint $table) {
            // إعادة عمود company_id ليكون اختياريًا
            $table->unsignedBigInteger('company_id')->nullable()->change();
        });
    }
};
