<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('inventory_units', function (Blueprint $table) {
            // إزالة القيد الفريد الحالي على حقل code
            $table->dropUnique('inventory_units_code_unique');

            // إضافة قيد فريد مركب يشمل company_id و code معًا
            $table->unique(['company_id', 'code'], 'inventory_units_company_id_code_unique');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('inventory_units', function (Blueprint $table) {
            // إزالة القيد الفريد المركب
            $table->dropUnique('inventory_units_company_id_code_unique');

            // إعادة القيد الفريد الأصلي على حقل code
            $table->unique('code', 'inventory_units_code_unique');
        });
    }
};
