<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('warehouses', function (Blueprint $table) {
            // إزالة قيد التفرد العام على عمود code
            $table->dropUnique('warehouses_code_unique');

            // إضافة قيد تفرد مركب على عمودي company_id و code
            $table->unique(['company_id', 'code'], 'warehouses_company_id_code_unique');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('warehouses', function (Blueprint $table) {
            // إزالة قيد التفرد المركب
            $table->dropUnique('warehouses_company_id_code_unique');

            // إعادة قيد التفرد العام على عمود code
            $table->unique('code', 'warehouses_code_unique');
        });
    }
};
