<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('elevators', function (Blueprint $table) {
            // حذف القيد الفريد الحالي على الرقم التسلسلي
            $table->dropUnique(['serial_number']);

            // إضافة قيد فريد جديد على مستوى الشركة الواحدة
            $table->unique(['company_id', 'serial_number'], 'elevators_company_serial_unique');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('elevators', function (Blueprint $table) {
            // حذف القيد الفريد على مستوى الشركة
            $table->dropUnique('elevators_company_serial_unique');

            // إعادة القيد الفريد على الرقم التسلسلي فقط
            $table->unique(['serial_number']);
        });
    }
};
