<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // إصلاح مشكلة تكرار حساب البنك الرئيسي

        // 1. حذف القيد الفريد الحالي
        Schema::table('chart_of_accounts', function (Blueprint $table) {
            $table->dropUnique('chart_of_accounts_company_account_unique');
        });

        // 2. إضافة قيد فريد جديد يستثني الحسابات المحذوفة
        DB::statement('
            CREATE UNIQUE INDEX chart_of_accounts_company_account_active_unique 
            ON chart_of_accounts (company_id, account_code) 
            WHERE deleted_at IS NULL
        ');

        // 3. تصحيح مستويات الحسابات البنكية
        DB::statement('
            UPDATE chart_of_accounts ca
            JOIN chart_of_accounts parent ON ca.parent_id = parent.id
            SET ca.level = parent.level + 1
            WHERE ca.is_bank_account = 1
        ');

        // 4. تصحيح الحسابات البنكية الرئيسية
        DB::statement('
            UPDATE chart_of_accounts ca
            JOIN chart_of_accounts current_assets ON current_assets.company_id = ca.company_id AND current_assets.account_code = "1100"
            SET ca.parent_id = current_assets.id, ca.level = current_assets.level + 1
            WHERE ca.account_code = "BANK" AND ca.parent_id != current_assets.id
        ');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // 1. حذف القيد الفريد الجديد
        DB::statement('DROP INDEX chart_of_accounts_company_account_active_unique ON chart_of_accounts');

        // 2. إعادة القيد الفريد القديم
        Schema::table('chart_of_accounts', function (Blueprint $table) {
            $table->unique(['company_id', 'account_code'], 'chart_of_accounts_company_account_unique');
        });
    }
};
