<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('maintenance_contracts', function (Blueprint $table) {
            // إزالة القيد الفريد الحالي على عمود contract_number
            $table->dropUnique(['contract_number']);

            // إضافة قيد فريد مركب يجمع بين company_id و contract_number
            $table->unique(['company_id', 'contract_number']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('maintenance_contracts', function (Blueprint $table) {
            // إزالة القيد الفريد المركب
            $table->dropUnique(['company_id', 'contract_number']);

            // إعادة القيد الفريد الأصلي على عمود contract_number
            $table->unique(['contract_number']);
        });
    }
};
