<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // إزالة القيد الفريد الحالي على حقل entry_number
        Schema::table('journal_entries', function (Blueprint $table) {
            $table->dropUnique(['entry_number']);
        });

        // إضافة قيد فريد جديد على مستوى الشركة
        Schema::table('journal_entries', function (Blueprint $table) {
            $table->unique(['company_id', 'entry_number'], 'journal_entries_company_entry_number_unique');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // إعادة القيد الفريد الأصلي
        Schema::table('journal_entries', function (Blueprint $table) {
            $table->dropUnique(['company_id', 'entry_number']);
        });

        Schema::table('journal_entries', function (Blueprint $table) {
            $table->unique(['entry_number']);
        });
    }
};
