<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('cash_registers', function (Blueprint $table) {
            // إزالة القيد الفريد الحالي من عمود code
            $table->dropUnique('cash_registers_code_unique');

            // إضافة قيد فريد مركب على code و company_id
            $table->unique(['code', 'company_id'], 'cash_registers_code_company_unique');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('cash_registers', function (Blueprint $table) {
            // إزالة القيد الفريد المركب
            $table->dropUnique('cash_registers_code_company_unique');

            // إعادة القيد الفريد الأصلي على عمود code
            $table->unique('code', 'cash_registers_code_unique');
        });
    }
};
