<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('companies', function (Blueprint $table) {
            // إضافة عمود primary_user_id إذا لم يكن موجودًا
            if (!Schema::hasColumn('companies', 'primary_user_id')) {
                $table->unsignedBigInteger('primary_user_id')->nullable();
                $table->foreign('primary_user_id')->references('id')->on('users')->onDelete('set null');
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('companies', function (Blueprint $table) {
            // حذف القيد الخارجي والعمود إذا كان موجودًا
            if (Schema::hasColumn('companies', 'primary_user_id')) {
                $table->dropForeign(['primary_user_id']);
                $table->dropColumn('primary_user_id');
            }
        });
    }
};
