<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('invoices', function (Blueprint $table) {
            // Cambiar el tipo de columna zatca_qr_code a LONGTEXT para permitir almacenar imágenes Base64 más grandes
            $table->longText('zatca_qr_code')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('invoices', function (Blueprint $table) {
            // Revertir el cambio a string
            $table->string('zatca_qr_code')->nullable()->change();
        });
    }
};
