<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // التحقق من وجود الفهرس قبل محاولة إزالته
        $indexExists = DB::select("
            SELECT COUNT(1) as index_exists
            FROM information_schema.statistics
            WHERE table_schema = DATABASE()
            AND table_name = 'branches'
            AND index_name = 'branches_code_unique'
        ");

        // إزالة الفهرس إذا كان موجوداً
        if ($indexExists[0]->index_exists > 0) {
            DB::statement('ALTER TABLE branches DROP INDEX branches_code_unique');
        }

        // التحقق من وجود الفهرس المركب قبل إضافته
        $compositeIndexExists = DB::select("
            SELECT COUNT(1) as index_exists
            FROM information_schema.statistics
            WHERE table_schema = DATABASE()
            AND table_name = 'branches'
            AND index_name = 'branches_company_id_code_unique'
        ");

        // إضافة الفهرس المركب إذا لم يكن موجوداً
        if ($compositeIndexExists[0]->index_exists == 0) {
            Schema::table('branches', function (Blueprint $table) {
                $table->unique(['company_id', 'code'], 'branches_company_id_code_unique');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // إزالة القيد الفريد المركب
        Schema::table('branches', function (Blueprint $table) {
            $table->dropUnique('branches_company_id_code_unique');
        });

        // إعادة القيد الفريد على حقل code
        Schema::table('branches', function (Blueprint $table) {
            $table->unique('code', 'branches_code_unique');
        });
    }
};
