<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('invoices', function (Blueprint $table) {
            // حقول الفوترة الإلكترونية لهيئة الزكاة والدخل
            $table->string('zatca_invoice_type')->default('standard')->after('invoice_number'); // نوع الفاتورة (standard, simplified, debit_note, credit_note)
            $table->string('zatca_invoice_hash')->nullable()->after('zatca_invoice_type'); // قيمة التشفير للفاتورة
            $table->string('zatca_qr_code')->nullable()->after('zatca_invoice_hash'); // رمز الاستجابة السريعة
            $table->string('zatca_uuid')->nullable()->after('zatca_qr_code'); // معرف فريد للفاتورة
            $table->string('zatca_pih')->nullable()->after('zatca_uuid'); // قيمة تشفير المعلومات السابقة
            $table->string('zatca_xml_path')->nullable()->after('zatca_pih'); // مسار ملف XML
            $table->string('zatca_compliance_status')->nullable()->after('zatca_xml_path'); // حالة التوافق مع الهيئة
            $table->string('zatca_clearance_status')->nullable()->after('zatca_compliance_status'); // حالة التخليص
            $table->string('zatca_reporting_status')->nullable()->after('zatca_clearance_status'); // حالة الإبلاغ
            $table->timestamp('zatca_reported_at')->nullable()->after('zatca_reporting_status'); // وقت الإبلاغ
            $table->string('zatca_invoice_reference')->nullable()->after('zatca_reported_at'); // رقم مرجعي للفاتورة
            $table->string('zatca_previous_invoice_hash')->nullable()->after('zatca_invoice_reference'); // قيمة تشفير الفاتورة السابقة
            $table->boolean('zatca_is_third_party_invoice')->default(false)->after('zatca_previous_invoice_hash'); // هل الفاتورة من طرف ثالث
            $table->boolean('zatca_is_nominal')->default(false)->after('zatca_is_third_party_invoice'); // هل الفاتورة اسمية
            $table->boolean('zatca_is_exports')->default(false)->after('zatca_is_nominal'); // هل الفاتورة للتصدير
            $table->boolean('zatca_is_summary')->default(false)->after('zatca_is_exports'); // هل الفاتورة ملخصة
            $table->boolean('zatca_is_self_billed')->default(false)->after('zatca_is_summary'); // هل الفاتورة ذاتية الإصدار
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('invoices', function (Blueprint $table) {
            $table->dropColumn([
                'zatca_invoice_type',
                'zatca_invoice_hash',
                'zatca_qr_code',
                'zatca_uuid',
                'zatca_pih',
                'zatca_xml_path',
                'zatca_compliance_status',
                'zatca_clearance_status',
                'zatca_reporting_status',
                'zatca_reported_at',
                'zatca_invoice_reference',
                'zatca_previous_invoice_hash',
                'zatca_is_third_party_invoice',
                'zatca_is_nominal',
                'zatca_is_exports',
                'zatca_is_summary',
                'zatca_is_self_billed'
            ]);
        });
    }
};
