<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('branches', function (Blueprint $table) {
            // إزالة الفهرس الفريد من حقل code إذا كان موجوداً
            if (Schema::hasTable('branches') && Schema::hasColumn('branches', 'code')) {
                // التحقق من وجود الفهرس قبل محاولة حذفه
                $sm = Schema::getConnection()->getDoctrineSchemaManager();
                $indexes = $sm->listTableIndexes('branches');

                if (array_key_exists('branches_code_unique', $indexes)) {
                    $table->dropUnique('branches_code_unique');
                }
            }

            // إضافة فهرس مركب على حقلي company_id و code
            $table->unique(['company_id', 'code'], 'branches_company_id_code_unique');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('branches', function (Blueprint $table) {
            // إزالة الفهرس المركب
            $table->dropUnique('branches_company_id_code_unique');

            // إعادة الفهرس الفريد إلى حقل code
            $table->unique('code', 'branches_code_unique');
        });
    }
};
