<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('chart_of_accounts', function (Blueprint $table) {
            // حذف القيد الفريد القديم على account_code فقط
            $table->dropUnique('chart_of_accounts_account_code_unique');

            // إضافة قيد فريد جديد على company_id و account_code معاً
            $table->unique(['company_id', 'account_code'], 'chart_of_accounts_company_account_unique');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('chart_of_accounts', function (Blueprint $table) {
            // حذف القيد الفريد المركب
            $table->dropUnique('chart_of_accounts_company_account_unique');

            // إعادة القيد الفريد القديم على account_code فقط
            $table->unique('account_code', 'chart_of_accounts_account_code_unique');
        });
    }
};
