<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('work_orders', function (Blueprint $table) {
            // إضافة عمود مرحلة المصعد
            $table->unsignedBigInteger('elevator_stage_id')->nullable()->after('project_phase_id');
            $table->foreign('elevator_stage_id')->references('id')->on('elevator_stages')->onDelete('set null');

            // جعل عمود مرحلة المشروع اختياريًا
            $table->unsignedBigInteger('project_phase_id')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('work_orders', function (Blueprint $table) {
            // حذف العلاقة الخارجية والعمود
            $table->dropForeign(['elevator_stage_id']);
            $table->dropColumn('elevator_stage_id');

            // إعادة عمود مرحلة المشروع إلى إلزامي
            $table->unsignedBigInteger('project_phase_id')->nullable(false)->change();
        });
    }
};
