<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('work_orders', function (Blueprint $table) {
            // تعديل حقل technician_id ليسمح بقيمة NULL
            $table->foreignId('technician_id')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('work_orders', function (Blueprint $table) {
            // إعادة حقل technician_id إلى الحالة الأصلية (غير قابل للقيمة NULL)
            $table->foreignId('technician_id')->nullable(false)->change();
        });
    }
};
