<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('elevator_stages', function (Blueprint $table) {
            $table->enum('status', ['open', 'paused', 'completed', 'archived'])->default('open')->after('is_active')->comment('حالة المرحلة: مفتوحة، متوقفة، مكتملة، مؤرشفة');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('elevator_stages', function (Blueprint $table) {
            $table->dropColumn('status');
        });
    }
};
