<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('elevators', function (Blueprint $table) {
            $table->date('free_maintenance_end_date')->nullable()->after('warranty_end_date');
            $table->date('control_warranty_end_date')->nullable()->after('free_maintenance_end_date');
            $table->date('machine_warranty_end_date')->nullable()->after('control_warranty_end_date');
            $table->date('delivery_date')->nullable()->after('machine_warranty_end_date');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('elevators', function (Blueprint $table) {
            $table->dropColumn('free_maintenance_end_date');
            $table->dropColumn('control_warranty_end_date');
            $table->dropColumn('machine_warranty_end_date');
            $table->dropColumn('delivery_date');
        });
    }
};
