<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('interaction_follow_ups', function (Blueprint $table) {
            $table->id();
            $table->foreignId('interaction_id')->constrained('customer_interactions')->onDelete('cascade');
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->dateTime('follow_up_date');
            $table->text('notes');
            $table->enum('outcome', ['positive', 'negative', 'neutral', 'pending'])->default('pending');
            $table->dateTime('next_follow_up_date')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('interaction_follow_ups');
    }
};
