<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('bank_transactions', function (Blueprint $table) {
            $table->string('deposit_method')->nullable()->after('transaction_type');
            $table->string('source')->nullable()->after('deposit_method');
            $table->text('additional_data')->nullable()->after('description');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('bank_transactions', function (Blueprint $table) {
            $table->dropColumn('deposit_method');
            $table->dropColumn('source');
            $table->dropColumn('additional_data');
        });
    }
};
