<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('elevator_parts', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')->constrained('companies')->onDelete('cascade');
            $table->string('name');
            $table->string('part_number')->nullable();
            $table->string('manufacturer')->nullable();
            $table->string('model')->nullable();
            $table->text('description')->nullable();
            $table->text('specifications')->nullable();
            $table->decimal('cost_price', 10, 2)->nullable();
            $table->decimal('selling_price', 10, 2)->nullable();
            $table->integer('min_stock_level')->default(0);
            $table->integer('current_stock')->default(0);
            $table->string('location')->nullable()->comment('موقع تخزين القطعة');
            $table->string('unit')->nullable()->comment('وحدة القياس');
            $table->boolean('is_active')->default(true);
            $table->timestamps();

            // إضافة فهرس للبحث السريع
            $table->index(['company_id', 'name']);
            $table->index(['company_id', 'part_number']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('elevator_parts');
    }
};
