<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('elevator_models', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')->constrained('companies')->onDelete('cascade');
            $table->foreignId('type_id')->nullable()->constrained('elevator_types')->nullOnDelete();
            $table->string('name');
            $table->string('code')->nullable();
            $table->string('manufacturer')->nullable();
            $table->integer('max_weight')->nullable()->comment('الوزن الأقصى بالكيلوجرام');
            $table->integer('max_persons')->nullable()->comment('الحد الأقصى لعدد الأشخاص');
            $table->integer('speed')->nullable()->comment('السرعة بالمتر/ثانية');
            $table->text('specifications')->nullable();
            $table->text('description')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();

            // إضافة فهرس للبحث السريع
            $table->index(['company_id', 'name']);
            $table->index(['company_id', 'type_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('elevator_models');
    }
};
