<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Primero verificamos si la tabla existe
        if (!Schema::hasTable('banks')) {
            // Si no existe, la creamos
            Schema::create('banks', function (Blueprint $table) {
                $table->id();
                $table->string('name');
                $table->string('code')->nullable();
                $table->string('swift_code', 50)->nullable();
                $table->text('address')->nullable();
                $table->string('contact_person')->nullable();
                $table->string('contact_phone', 20)->nullable();
                $table->string('contact_email')->nullable();
                $table->text('notes')->nullable();
                $table->boolean('is_active')->default(true);
                $table->foreignId('company_id')->nullable();
                $table->softDeletes();
                $table->timestamps();
            });
        } else {
            // Si existe, nos aseguramos de que tenga todos los campos necesarios
            Schema::table('banks', function (Blueprint $table) {
                if (!Schema::hasColumn('banks', 'company_id')) {
                    $table->foreignId('company_id')->nullable();
                } else {
                    // Modificamos la columna para que acepte valores nulos
                    DB::statement('ALTER TABLE banks MODIFY company_id BIGINT UNSIGNED NULL');
                }

                // Aseguramos que existan todos los campos necesarios
                if (!Schema::hasColumn('banks', 'name')) {
                    $table->string('name');
                }
                if (!Schema::hasColumn('banks', 'code')) {
                    $table->string('code')->nullable();
                }
                if (!Schema::hasColumn('banks', 'swift_code')) {
                    $table->string('swift_code', 50)->nullable();
                }
                if (!Schema::hasColumn('banks', 'address')) {
                    $table->text('address')->nullable();
                }
                if (!Schema::hasColumn('banks', 'contact_person')) {
                    $table->string('contact_person')->nullable();
                }
                if (!Schema::hasColumn('banks', 'contact_phone')) {
                    $table->string('contact_phone', 20)->nullable();
                }
                if (!Schema::hasColumn('banks', 'contact_email')) {
                    $table->string('contact_email')->nullable();
                }
                if (!Schema::hasColumn('banks', 'notes')) {
                    $table->text('notes')->nullable();
                }
                if (!Schema::hasColumn('banks', 'is_active')) {
                    $table->boolean('is_active')->default(true);
                }
                if (!Schema::hasColumn('banks', 'deleted_at')) {
                    $table->softDeletes();
                }
                if (!Schema::hasColumn('banks', 'created_at')) {
                    $table->timestamps();
                }
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('banks', function (Blueprint $table) {
            //
        });
    }
};
