<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cheques', function (Blueprint $table) {
            $table->id();
            $table->string('cheque_number');
            $table->string('cheque_type'); // incoming, outgoing
            $table->foreignId('bank_account_id')->constrained('bank_accounts')->onDelete('cascade');
            $table->date('cheque_date');
            $table->date('due_date');
            $table->decimal('amount', 15, 2);
            $table->string('payee_name');
            $table->string('payee_type')->nullable(); // customer, supplier, employee, other
            $table->foreignId('payee_id')->nullable(); // ID of customer, supplier, etc.
            $table->string('bank_name')->nullable(); // For incoming cheques
            $table->string('status')->default('pending'); // pending, deposited, collected, returned, cancelled
            $table->date('status_change_date')->nullable();
            $table->foreignId('transaction_id')->nullable()->constrained('bank_transactions')->onDelete('set null');
            $table->foreignId('journal_entry_id')->nullable()->constrained('journal_entries')->onDelete('set null');
            $table->foreignId('created_by')->constrained('users')->onDelete('cascade');
            $table->text('notes')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cheques');
    }
};
