<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('bank_transactions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('bank_account_id')->constrained('bank_accounts')->onDelete('cascade');
            $table->string('transaction_type'); // deposit, withdrawal, transfer
            $table->foreignId('from_account_id')->nullable()->constrained('bank_accounts')->onDelete('set null');
            $table->foreignId('to_account_id')->nullable()->constrained('bank_accounts')->onDelete('set null');
            $table->string('reference_number')->nullable();
            $table->date('transaction_date');
            $table->decimal('amount', 15, 2);
            $table->string('payment_method')->nullable(); // cash, cheque, transfer
            $table->string('cheque_number')->nullable();
            $table->foreignId('journal_entry_id')->nullable()->constrained('journal_entries')->onDelete('set null');
            $table->foreignId('created_by')->constrained('users')->onDelete('cascade');
            $table->text('description')->nullable();
            $table->string('status')->default('completed'); // pending, completed, cancelled
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('bank_transactions');
    }
};
