<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // إنشاء جدول chart_of_accounts إذا لم يكن موجودًا
        if (!Schema::hasTable('chart_of_accounts')) {
            Schema::create('chart_of_accounts', function (Blueprint $table) {
                $table->id();
                $table->foreignId('company_id')->nullable()->constrained('companies')->onDelete('cascade');
                $table->foreignId('parent_id')->nullable()->references('id')->on('chart_of_accounts')->onDelete('cascade');
                $table->string('account_code', 20);
                $table->string('name');
                $table->string('name_en')->nullable();
                $table->enum('account_type', ['asset', 'liability', 'equity', 'revenue', 'expense']);
                $table->string('sub_type')->nullable();
                $table->text('description')->nullable();
                $table->boolean('is_active')->default(true);
                $table->boolean('is_system')->default(false);
                $table->decimal('opening_balance', 15, 2)->default(0);
                $table->decimal('current_balance', 15, 2)->default(0);
                $table->string('currency', 10)->default('SAR');
                $table->enum('balance_type', ['debit', 'credit'])->default('debit');
                $table->boolean('is_cash_account')->default(false);
                $table->boolean('is_bank_account')->default(false);
                $table->boolean('allow_entries')->default(true);
                $table->integer('level')->default(1);
                $table->timestamps();
                $table->softDeletes();

                // الفهارس
                $table->index(['company_id', 'account_type']);
                $table->index(['company_id', 'parent_id']);
            });
        } else {
            // إضافة الأعمدة المفقودة إذا كان الجدول موجودًا
            Schema::table('chart_of_accounts', function (Blueprint $table) {
                if (!Schema::hasColumn('chart_of_accounts', 'sub_type')) {
                    $table->string('sub_type')->nullable()->after('account_type');
                }
                if (!Schema::hasColumn('chart_of_accounts', 'current_balance')) {
                    $table->decimal('current_balance', 15, 2)->default(0)->after('opening_balance');
                }
                if (!Schema::hasColumn('chart_of_accounts', 'currency')) {
                    $table->string('currency', 10)->default('SAR')->after('current_balance');
                }
                if (!Schema::hasColumn('chart_of_accounts', 'is_cash_account')) {
                    $table->boolean('is_cash_account')->default(false)->after('currency');
                }
                if (!Schema::hasColumn('chart_of_accounts', 'is_bank_account')) {
                    $table->boolean('is_bank_account')->default(false)->after('is_cash_account');
                }
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // لا نقوم بحذف الجدول في حالة التراجع، فقط نحذف الأعمدة المضافة
        Schema::table('chart_of_accounts', function (Blueprint $table) {
            $table->dropColumn(['sub_type', 'current_balance', 'currency', 'is_cash_account', 'is_bank_account']);
        });
    }
};
