<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('cash_transactions', function (Blueprint $table) {
            // إزالة قيد المفتاح الأجنبي لحقل related_cash_register_id
            $table->dropForeign(['related_cash_register_id']);

            // تعديل الحقل ليكون مجرد حقل عادي بدون قيد مفتاح أجنبي
            $table->unsignedBigInteger('related_cash_register_id')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('cash_transactions', function (Blueprint $table) {
            // إعادة إضافة قيد المفتاح الأجنبي
            $table->foreign('related_cash_register_id')->references('id')->on('cash_registers');
        });
    }
};
