<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('maintenance_requests', function (Blueprint $table) {
            // Drop the existing assigned_to column if it exists
            if (Schema::hasColumn('maintenance_requests', 'assigned_to')) {
                $table->dropForeign(['assigned_to']);
                $table->dropColumn('assigned_to');
            }

            // Add new columns
            $table->foreignId('assigned_team_id')->nullable()->after('created_by')->constrained('maintenance_teams')->onDelete('set null');
            $table->foreignId('assigned_user_id')->nullable()->after('assigned_team_id')->constrained('users')->onDelete('set null');

            // Add additional columns that might be missing
            if (!Schema::hasColumn('maintenance_requests', 'request_number')) {
                $table->string('request_number')->unique()->after('id');
            }

            if (!Schema::hasColumn('maintenance_requests', 'title')) {
                $table->string('title')->after('request_number');
            }

            if (!Schema::hasColumn('maintenance_requests', 'problem_details')) {
                $table->text('problem_details')->nullable()->after('description');
            }

            if (!Schema::hasColumn('maintenance_requests', 'scheduled_date')) {
                $table->dateTime('scheduled_date')->nullable()->after('requested_date');
            }

            if (!Schema::hasColumn('maintenance_requests', 'completed_date')) {
                $table->dateTime('completed_date')->nullable()->after('scheduled_date');
            }

            if (!Schema::hasColumn('maintenance_requests', 'completion_notes')) {
                $table->text('completion_notes')->nullable()->after('completed_date');
            }

            if (!Schema::hasColumn('maintenance_requests', 'is_emergency')) {
                $table->boolean('is_emergency')->default(false)->after('completion_notes');
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('maintenance_requests', function (Blueprint $table) {
            // Drop the new columns
            if (Schema::hasColumn('maintenance_requests', 'assigned_team_id')) {
                $table->dropForeign(['assigned_team_id']);
                $table->dropColumn('assigned_team_id');
            }

            if (Schema::hasColumn('maintenance_requests', 'assigned_user_id')) {
                $table->dropForeign(['assigned_user_id']);
                $table->dropColumn('assigned_user_id');
            }

            // Add back the original assigned_to column
            $table->foreignId('assigned_to')->nullable()->after('requested_date')->constrained('users')->onDelete('set null');

            // Drop additional columns that were added
            if (Schema::hasColumn('maintenance_requests', 'request_number')) {
                $table->dropColumn('request_number');
            }

            if (Schema::hasColumn('maintenance_requests', 'title')) {
                $table->dropColumn('title');
            }

            if (Schema::hasColumn('maintenance_requests', 'problem_details')) {
                $table->dropColumn('problem_details');
            }

            if (Schema::hasColumn('maintenance_requests', 'scheduled_date')) {
                $table->dropColumn('scheduled_date');
            }

            if (Schema::hasColumn('maintenance_requests', 'completed_date')) {
                $table->dropColumn('completed_date');
            }

            if (Schema::hasColumn('maintenance_requests', 'completion_notes')) {
                $table->dropColumn('completion_notes');
            }

            if (Schema::hasColumn('maintenance_requests', 'is_emergency')) {
                $table->dropColumn('is_emergency');
            }
        });
    }
};
