<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('maintenance_requests', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')->constrained('companies');
            $table->foreignId('branch_id')->nullable()->constrained('branches');
            $table->foreignId('customer_id')->constrained('customers');
            $table->foreignId('elevator_id')->constrained('elevators');
            $table->foreignId('created_by')->constrained('users');
            $table->foreignId('assigned_team_id')->nullable()->constrained('maintenance_teams');
            $table->foreignId('assigned_user_id')->nullable()->constrained('users');
            $table->string('request_number')->unique();
            $table->string('title');
            $table->text('description');
            $table->text('problem_details')->nullable();
            $table->enum('priority', ['low', 'medium', 'high', 'urgent'])->default('medium');
            $table->enum('status', ['pending', 'assigned', 'in_progress', 'completed', 'cancelled'])->default('pending');
            $table->dateTime('requested_date');
            $table->dateTime('scheduled_date')->nullable();
            $table->dateTime('completed_date')->nullable();
            $table->text('completion_notes')->nullable();
            $table->boolean('is_emergency')->default(false);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('maintenance_requests');
    }
};
