<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('project_elevators', function (Blueprint $table) {
            $table->id();
            $table->foreignId('installation_project_id')->constrained()->onDelete('cascade');
            $table->foreignId('elevator_id')->nullable()->constrained()->onDelete('set null');
            $table->string('elevator_type');
            $table->string('model');
            $table->string('manufacturer');
            $table->integer('capacity')->comment('in kg');
            $table->integer('floors_count');
            $table->decimal('speed', 5, 2)->comment('in m/s');
            $table->decimal('unit_price', 12, 2);
            $table->enum('status', ['pending', 'ordered', 'delivered', 'installed', 'tested', 'completed'])->default('pending');
            $table->date('expected_delivery_date')->nullable();
            $table->date('actual_delivery_date')->nullable();
            $table->date('expected_installation_date')->nullable();
            $table->date('actual_installation_date')->nullable();
            $table->text('specifications')->nullable();
            $table->text('notes')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('project_elevators');
    }
};
