<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('maintenance_team_members', function (Blueprint $table) {
            $table->id();
            $table->foreignId('team_id')->constrained('maintenance_teams');
            $table->foreignId('user_id')->constrained('users');
            $table->string('role')->nullable();
            $table->timestamps();

            // Prevent duplicate members in the same team
            $table->unique(['team_id', 'user_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('maintenance_team_members');
    }
};
